/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.client;

import baguchan.hunters_return.client.ModModelLayers;
import baguchan.hunters_return.client.model.HunterModel;
import baguchan.hunters_return.client.model.OldHunterModel;
import baguchan.hunters_return.client.render.BoomerangRender;
import baguchan.hunters_return.client.render.HunterRender;
import baguchan.hunters_return.init.HunterEntityRegistry;
import baguchan.hunters_return.init.HunterItems;
import baguchan.hunters_return.item.MiniCrossBowItem;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="hunters_return", value={Dist.CLIENT})
public class HunterRenderingRegistry {
    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(HunterEntityRegistry.HUNTERILLAGER.get(), HunterRender::new);
        event.registerEntityRenderer(HunterEntityRegistry.BOOMERANG.get(), BoomerangRender::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModModelLayers.HUNTER, HunterModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.HUNTER_OLD, OldHunterModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerItemModel(ModelEvent.ModifyBakingResult event) {
        ItemProperties.register((Item)HunterItems.MINI_CROSSBOW.asItem(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (p_351682_, p_351683_, p_351684_, p_351685_) -> {
            if (p_351684_ == null) {
                return 0.0f;
            }
            return CrossbowItem.isCharged((ItemStack)p_351682_) ? 0.0f : (float)(p_351682_.getUseDuration(p_351684_) - p_351684_.getUseItemRemainingTicks()) / (float)MiniCrossBowItem.getChargeDuration((ItemStack)p_351682_, (LivingEntity)p_351684_);
        });
        ItemProperties.register((Item)HunterItems.MINI_CROSSBOW.asItem(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (p_174605_, p_174606_, p_174607_, p_174608_) -> p_174607_ != null && p_174607_.isUsingItem() && p_174607_.getUseItem() == p_174605_ && !CrossbowItem.isCharged((ItemStack)p_174605_) ? 1.0f : 0.0f);
        ItemProperties.register((Item)HunterItems.MINI_CROSSBOW.asItem(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (p_275891_, p_275892_, p_275893_, p_275894_) -> CrossbowItem.isCharged((ItemStack)p_275891_) ? 1.0f : 0.0f);
        ItemProperties.register((Item)HunterItems.MINI_CROSSBOW.asItem(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), (p_329796_, p_329797_, p_329798_, p_329799_) -> {
            ChargedProjectiles chargedprojectiles = (ChargedProjectiles)p_329796_.get(DataComponents.CHARGED_PROJECTILES);
            return chargedprojectiles != null && chargedprojectiles.contains(Items.FIREWORK_ROCKET) ? 1.0f : 0.0f;
        });
    }
}

