/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.mixin;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements DataComponentHolder {
    @Shadow
    public abstract Item getItem();

    @Inject(at={@At(value="HEAD")}, method={"getMaxDamage"}, cancellable=true)
    public void getMaxDamageProxy(CallbackInfoReturnable<Integer> cir) {
        Item item = this.getItem();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem bucketItem = (UniversalBucketItem)item;
            cir.setReturnValue((Object)bucketItem.getDurability());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isDamageableItem"}, cancellable=true)
    public void isDamageableItemProxy(CallbackInfoReturnable<Boolean> cir) {
        Item item = this.getItem();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem bucketItem = (UniversalBucketItem)item;
            cir.setReturnValue((Object)(bucketItem.getDurability() > 0 && !this.has(DataComponents.UNBREAKABLE) ? 1 : 0));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getMaxStackSize"}, cancellable=true)
    public void getMaxStackSizeProxy(CallbackInfoReturnable<Integer> cir) {
        Item item = this.getItem();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem bucketItem = (UniversalBucketItem)item;
            cir.setReturnValue((Object)bucketItem.getMaxStackSize((ItemStack)this));
        }
    }
}

