/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.config;

import it.crystalnest.cobweb.api.config.ConfigType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class CobwebConfig {
    private static final Map<String, Pair<? extends CobwebConfig, ModConfigSpec>> CONFIGS = new HashMap<String, Pair<? extends CobwebConfig, ModConfigSpec>>();
    private static final Pair<? extends CobwebConfig, ModConfigSpec> NULL_CONFIG = Pair.of(null, null);

    protected CobwebConfig(ModConfigSpec.Builder builder) {
        this.define(builder);
        builder.build();
    }

    protected static <T extends CobwebConfig> void register(String modId, ConfigType type, Function<ModConfigSpec.Builder, T> constructor) {
        CONFIGS.put(CobwebConfig.getId(modId, type), (Pair<? extends CobwebConfig, ModConfigSpec>)new ModConfigSpec.Builder().configure(constructor));
    }

    @Nullable
    protected static <T extends CobwebConfig> T getConfig(String modId, ConfigType type) {
        return (T)(CONFIGS.containsKey(CobwebConfig.getId(modId, type)) ? (CobwebConfig)CONFIGS.get(CobwebConfig.getId(modId, type)).getLeft() : null);
    }

    @Nullable
    protected static ModConfigSpec getSpec(String modId, ConfigType type) {
        return (ModConfigSpec)CONFIGS.getOrDefault(CobwebConfig.getId(modId, type), NULL_CONFIG).getRight();
    }

    protected static String getId(String modId, ConfigType type) {
        return modId + "_" + String.valueOf((Object)type);
    }

    public void register() {
    }

    protected abstract void define(ModConfigSpec.Builder var1);

    protected boolean stringListValidator(Object element) {
        String string;
        return element instanceof String && !(string = (String)element).isBlank();
    }
}

