/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record SummoningBlockRecipe(SizedIngredient input, Ingredient catalyst, String mob) implements Recipe<RecipeInput>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add((Object)this.input.ingredient());
        return ingredients;
    }

    public boolean matches(RecipeInput container, @NotNull Level level) {
        return this.input.test(container.getItem(1));
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<SummoningBlockRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<SummoningBlockRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.FLAT_CODEC.fieldOf("input").forGetter(SummoningBlockRecipe::input), (App)Ingredient.CODEC.fieldOf("catalyst").forGetter(SummoningBlockRecipe::catalyst), (App)Codec.STRING.fieldOf("mob").forGetter(SummoningBlockRecipe::mob)).apply((Applicative)instance, Serializer::createSummoningBlockRecipe));
        private final StreamCodec<RegistryFriendlyByteBuf, SummoningBlockRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<SummoningBlockRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SummoningBlockRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static SummoningBlockRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient input = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            Ingredient catalyst = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            String mob = buffer.readUtf();
            return new SummoningBlockRecipe(input, catalyst, mob);
        }

        private static void write(RegistryFriendlyByteBuf buffer, SummoningBlockRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.catalyst);
            buffer.writeUtf(recipe.mob);
        }

        private static SummoningBlockRecipe createSummoningBlockRecipe(SizedIngredient input, Ingredient catalyst, String mob) {
            return new SummoningBlockRecipe(input, catalyst, mob);
        }
    }

    public static class Type
    implements RecipeType<SummoningBlockRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

