/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.event;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.block.custom.EnderScramblerBlock;
import com.benbenlaw.opolisutilities.block.entity.custom.EnderScramblerBlockEntity;
import com.benbenlaw.opolisutilities.config.ConfigFile;
import com.benbenlaw.opolisutilities.config.StartupBlockConfigFile;
import com.benbenlaw.opolisutilities.config.StartupItemConfigFile;
import com.benbenlaw.opolisutilities.item.ModDataComponents;
import com.benbenlaw.opolisutilities.item.ModItems;
import com.benbenlaw.opolisutilities.item.custom.AnimalNetItem;
import com.benbenlaw.opolisutilities.networking.payload.PortableGUISelectorPayload;
import com.benbenlaw.opolisutilities.sound.ModSounds;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="opolisutilities")
public class ModEvents {
    public static BlockPos globalEntity;
    public static Level globalLevel;
    public static final List<String> TAGS_TO_REMOVE;

    @SubscribeEvent
    public static void cancelEndermanTeleportation(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EnderMan) {
            BlockPos pos = entity.getOnPos();
            int maxRange = (Integer)StartupBlockConfigFile.maxScramblerRange.get();
            for (int x = -maxRange; x <= maxRange; ++x) {
                for (int y = -maxRange; y <= maxRange; ++y) {
                    for (int z = -maxRange; z <= maxRange; ++z) {
                        BlockEntity enderScramblerBlockEntity;
                        BlockPos p = pos.offset(x, y, z);
                        BlockState state = entity.level().getBlockState(p);
                        if (!state.is((Block)ModBlocks.ENDER_SCRAMBLER.get()) || !((enderScramblerBlockEntity = entity.level().getBlockEntity(p)) instanceof EnderScramblerBlockEntity)) continue;
                        EnderScramblerBlockEntity e = (EnderScramblerBlockEntity)enderScramblerBlockEntity;
                        int r1 = e.SCRAMBLER_RANGE;
                        for (int x1 = -r1; x1 <= r1; ++x1) {
                            for (int y1 = -r1; y1 <= r1; ++y1) {
                                for (int z1 = -r1; z1 <= r1; ++z1) {
                                    BlockPos p1 = pos.offset(x1, y1, z1);
                                    BlockState state1 = entity.level().getBlockState(p1);
                                    if (!state1.is((Block)ModBlocks.ENDER_SCRAMBLER.get()) || !((Boolean)state1.getValue((Property)EnderScramblerBlock.POWERED)).equals(true)) continue;
                                    event.setCanceled(true);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void getPlayerDeathPoint(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            globalEntity = entity.getOnPos();
            globalLevel = entity.level();
        }
    }

    @SubscribeEvent
    public static void addDeathStoneOnPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        ItemStack deathStoneItem = new ItemStack((ItemLike)ModItems.DEATH_STONE.get());
        if (globalEntity != null && globalLevel != null) {
            deathStoneItem.set((DataComponentType)ModDataComponents.INT_X.get(), (Object)globalEntity.getX());
            deathStoneItem.set((DataComponentType)ModDataComponents.INT_Y.get(), (Object)globalEntity.getY());
            deathStoneItem.set((DataComponentType)ModDataComponents.INT_Z.get(), (Object)globalEntity.getZ());
            ResourceLocation dim = globalLevel.dimension().location();
            deathStoneItem.set((DataComponentType)ModDataComponents.DIMENSION.get(), (Object)(dim.getNamespace() + ":" + dim.getPath()));
        }
        if (((Boolean)StartupItemConfigFile.shouldPlayerGetDeathStoneOnDeath.get()).booleanValue()) {
            if (((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_KEEPINVENTORY)).get()) {
                level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), deathStoneItem));
            }
            if (!((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_KEEPINVENTORY)).get()) {
                player.addItem(deathStoneItem);
            }
        }
    }

    @SubscribeEvent
    public static void addLootBoxesToEntities(LivingDeathEvent event) {
        Vec3 entityPos = event.getEntity().position();
        Level world = event.getEntity().level();
        LivingEntity e = event.getEntity();
        if (!(e instanceof ServerPlayer) && Math.random() > (Double)ConfigFile.basicLootBoxDropChance.get()) {
            world.addFreshEntity((Entity)new ItemEntity(world, entityPos.x(), entityPos.y(), entityPos.z(), new ItemStack((ItemLike)ModItems.BASIC_LOOT_BOX.get())));
        }
    }

    @SubscribeEvent
    public static void sheepFollowCrook(EntityJoinLevelEvent event) {
        Sheep sheep;
        int priority;
        Entity entity = event.getEntity();
        if (entity instanceof Sheep && (priority = ModEvents.getTemptGoalPriority((Mob)(sheep = (Sheep)entity))) >= 0) {
            sheep.goalSelector.addGoal(priority, (Goal)new TemptGoal((PathfinderMob)sheep, 1.1, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CROOK.get()}), false));
        }
    }

    public static int getTemptGoalPriority(Mob mob) {
        return mob.goalSelector.getAvailableGoals().stream().filter(goal -> goal.getGoal() instanceof TemptGoal).findFirst().map(WrappedGoal::getPriority).orElse(-1);
    }

    @SubscribeEvent
    public static void onEntityRightClickEvent(PlayerInteractEvent.EntityInteract event) {
        Level level = event.getLevel();
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        Entity livingEntity = event.getTarget();
        if (!level.isClientSide() && stack.getItem() instanceof AnimalNetItem && stack.get((DataComponentType)ModDataComponents.ENTITY_TYPE.get()) == null) {
            boolean captureVillagers;
            ItemStack itemstack = player.getItemInHand(hand);
            DataComponentMap resultItemWithDataComponents = itemstack.getComponents();
            itemstack.applyComponents(resultItemWithDataComponents);
            boolean hostileMobs = (Boolean)StartupItemConfigFile.animalNetHostileMobs.get();
            boolean waterMobs = (Boolean)StartupItemConfigFile.animalNetWaterMobs.get();
            boolean animalMobs = (Boolean)StartupItemConfigFile.animalNetAnimalMobs.get();
            boolean villagerMobs = (Boolean)StartupItemConfigFile.animalNetVillagerMobs.get();
            boolean captureHostile = livingEntity instanceof Monster && hostileMobs;
            boolean captureWater = livingEntity instanceof WaterAnimal && waterMobs;
            boolean captureAnimal = livingEntity instanceof Animal && animalMobs;
            boolean bl = captureVillagers = livingEntity instanceof Villager && villagerMobs;
            if (!level.isClientSide()) {
                if (captureHostile || captureWater || captureAnimal || captureVillagers || livingEntity.isAlliedTo((Entity)player)) {
                    CompoundTag nbt = new CompoundTag();
                    livingEntity.saveWithoutId(nbt);
                    TAGS_TO_REMOVE.forEach(arg_0 -> ((CompoundTag)nbt).remove(arg_0));
                    itemstack.set((DataComponentType)ModDataComponents.ENTITY_TYPE.get(), (Object)EntityType.getKey((EntityType)livingEntity.getType()).toString());
                    itemstack.set((DataComponentType)ModDataComponents.ENTITY_DATA.get(), (Object)nbt);
                    livingEntity.remove(Entity.RemovalReason.DISCARDED);
                    player.sendSystemMessage((Component)Component.translatable((String)"tooltips.animal_net.mob_caught").withStyle(ChatFormatting.GREEN));
                    level.playSound(null, livingEntity.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"tooltips.animal_net.not_compatible_mob").withStyle(ChatFormatting.RED));
                }
            }
        }
    }

    @SubscribeEvent
    public static void doorBellSounds(PlayerInteractEvent.RightClickBlock event) {
        if (((Boolean)ConfigFile.woodenButtonsMakeDoorbellSound.get()).booleanValue()) {
            Level level = event.getLevel();
            BlockState state = event.getLevel().getBlockState(event.getPos());
            if (!level.isClientSide() && state.is(BlockTags.WOODEN_BUTTONS)) {
                level.playSound(null, event.getPos(), ModSounds.DOORBELL.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onScrollWheelUse(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        ItemStack itemStack = player.getMainHandItem();
        double scrollDelta = event.getScrollDeltaY();
        if (player.isCrouching() && (Screen.hasControlDown() || Screen.hasAltDown()) && scrollDelta != 0.0 && itemStack.is(ModItems.PORTABLE_GUI)) {
            boolean increase;
            int locationValue = 0;
            if (itemStack.get(ModDataComponents.LOCATION_VALUE) != null) {
                locationValue = (Integer)itemStack.get(ModDataComponents.LOCATION_VALUE);
            }
            boolean bl = increase = scrollDelta > 0.0;
            if (increase) {
                if (++locationValue > 5) {
                    locationValue = 1;
                }
            } else if (--locationValue < 1) {
                locationValue = 5;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new PortableGUISelectorPayload(player.getInventory().selected, increase, locationValue), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
        }
    }

    static {
        TAGS_TO_REMOVE = List.of("SleepingX", "SleepingY", "SleepingZ");
    }
}

