/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.mod.crafting.CoffeeIngredientRecipe;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemCoffee
extends ItemBase {
    private static final FoodProperties FOOD = new FoodProperties.Builder().nutrition(8).saturationModifier(5.0f).alwaysEdible().build();

    public ItemCoffee() {
        super(ActuallyItems.defaultProps().food(FOOD).durability(3).setNoRepair());
    }

    @Nullable
    public static RecipeHolder<CoffeeIngredientRecipe> getIngredientRecipeFromStack(ItemStack stack) {
        for (RecipeHolder<CoffeeIngredientRecipe> recipeHolder : ActuallyAdditionsAPI.COFFEE_MACHINE_INGREDIENTS) {
            if (!((CoffeeIngredientRecipe)recipeHolder.value()).getIngredient().test(stack)) continue;
            return recipeHolder;
        }
        return null;
    }

    public static void applyPotionEffectsFromStack(ItemStack stack, LivingEntity player) {
        MobEffectInstance[] effects = ActuallyAdditionsAPI.methodHandler.getEffectsFromStack(stack);
        if (effects != null && effects.length > 0) {
            for (MobEffectInstance effect : effects) {
                player.addEffect(new MobEffectInstance(effect.getEffect(), effect.getDuration() * 20, effect.getAmplifier()));
            }
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        ItemStack theStack = stack.copy();
        super.finishUsingItem(stack, level, livingEntity);
        ItemCoffee.applyPotionEffectsFromStack(theStack, livingEntity);
        theStack.setDamageValue(theStack.getDamageValue() + 1);
        if (theStack.getMaxDamage() - theStack.getDamageValue() <= 0) {
            return new ItemStack((ItemLike)ActuallyItems.EMPTY_CUP.get());
        }
        return theStack;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag advanced) {
        MobEffectInstance[] effects = ActuallyAdditionsAPI.methodHandler.getEffectsFromStack(stack);
        if (effects != null) {
            for (MobEffectInstance effect : effects) {
                tooltip.add((Component)Component.translatable((String)effect.getDescriptionId()).append(" " + (effect.getAmplifier() + 1) + ", " + StringUtil.formatTickDuration((int)effect.getDuration(), (float)1.0f)).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.actuallyadditions.coffeeCup.noEffect").withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public static class MilkIngredient
    extends CoffeeIngredient {
        public MilkIngredient(Ingredient ingredient) {
            super(ingredient, 0, new MobEffectInstance[0]);
        }

        @Override
        public boolean effect(ItemStack stack) {
            if (this.effects == null || this.effects.length > 0) {
                // empty if block
            }
            this.effects = null;
            return true;
        }

        @Override
        public String getExtraText() {
            return I18n.get((String)"jei.actuallyadditions.coffee.extra.milk", (Object[])new Object[0]);
        }
    }
}

