/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class MiningLensRecipe
implements Recipe<RecipeInput>,
WeightedEntry {
    public static final String NAME = "mining_lens";
    private final int weight;
    private final Ingredient input;
    private final ItemStack output;

    public MiningLensRecipe(Ingredient input, int weight, ItemStack output) {
        this.weight = weight;
        this.input = input;
        this.output = output;
    }

    public Weight getWeight() {
        return Weight.of((int)this.weight);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public boolean matches(ItemStack test) {
        return this.input.test(test);
    }

    public boolean matches(RecipeInput pInv, Level pLevel) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput pInv, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.MINING_LENS_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.MINING_LENS.get();
    }

    public static class Serializer
    implements RecipeSerializer<MiningLensRecipe> {
        private static final MapCodec<MiningLensRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)Codec.INT.fieldOf("weight").forGetter(recipe -> recipe.weight), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)instance, MiningLensRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MiningLensRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<MiningLensRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MiningLensRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static MiningLensRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            int weight = pBuffer.readInt();
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer);
            return new MiningLensRecipe(ingredient, weight, result);
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer, MiningLensRecipe pRecipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.input);
            pBuffer.writeInt(pRecipe.weight);
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.output);
        }
    }
}

