/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.wire.WireNode;
import java.util.AbstractQueue;
import java.util.Iterator;

public class SimpleQueue
extends AbstractQueue<WireNode> {
    private WireNode head;
    private WireNode tail;
    private int size;

    SimpleQueue() {
    }

    @Override
    public boolean offer(WireNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (this.tail == null) {
            this.head = this.tail = node;
        } else {
            this.tail.next_wire = node;
            this.tail = node;
        }
        ++this.size;
        return true;
    }

    @Override
    public WireNode poll() {
        if (this.head == null) {
            return null;
        }
        WireNode node = this.head;
        WireNode next = node.next_wire;
        if (next == null) {
            this.tail = null;
            this.head = null;
        } else {
            node.next_wire = null;
            this.head = next;
        }
        --this.size;
        return node;
    }

    @Override
    public WireNode peek() {
        return this.head;
    }

    @Override
    public void clear() {
        WireNode node = this.head;
        while (node != null) {
            WireNode n = node;
            node = node.next_wire;
            n.next_wire = null;
        }
        this.head = null;
        this.tail = null;
        this.size = 0;
    }

    @Override
    public Iterator<WireNode> iterator() {
        return new SimpleIterator(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    private class SimpleIterator
    implements Iterator<WireNode> {
        private WireNode curr;
        private WireNode next;

        private SimpleIterator(SimpleQueue simpleQueue) {
            this.next = simpleQueue.head;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null && this.curr != null) {
                this.next = this.curr.next_wire;
            }
            return this.next != null;
        }

        @Override
        public WireNode next() {
            this.curr = this.next;
            this.next = this.curr.next_wire;
            return this.curr;
        }
    }
}

