/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import trofers.trophy.Trophy;
import trofers.trophy.components.Animation;
import trofers.trophy.components.ColorInfo;
import trofers.trophy.components.DisplayInfo;
import trofers.trophy.components.EffectInfo;
import trofers.trophy.components.EntityInfo;
import trofers.util.ConditionsHelper;

public abstract class TrophyBuilder<T extends TrophyBuilder<T>> {
    private Optional<Component> name = Optional.empty();
    private final List<Component> tooltipLines = new ArrayList<Component>();
    private DisplayInfo displayInfo = DisplayInfo.NONE;
    private Animation animation = Animation.STATIC;
    private ColorInfo colorInfo = ColorInfo.NONE;
    private EffectInfo effectInfo = EffectInfo.NONE;
    private boolean isHidden = false;
    private final Set<String> requiredMods = new HashSet<String>();

    public Trophy build() {
        return new Trophy(this.name, this.tooltipLines, this.displayInfo, this.animation, this.getDisplayItem(), this.getEntityInfo(), this.colorInfo, this.effectInfo, this.isHidden);
    }

    protected abstract ItemStack getDisplayItem();

    protected abstract Optional<EntityInfo> getEntityInfo();

    public T requiresMod(String modId) {
        if (!modId.equals("trofers") && !modId.equals("minecraft")) {
            this.requiredMods.add(modId);
        }
        return (T)this;
    }

    public T name(@Nullable Component name) {
        this.name = Optional.ofNullable(name);
        return (T)this;
    }

    public T addTooltipLine(Component component) {
        this.tooltipLines.add(component);
        return (T)this;
    }

    public T offset(double xOffset, double yOffset, double zOffset) {
        this.displayInfo = new DisplayInfo(new Vec3(xOffset, yOffset, zOffset), this.displayInfo.rotation(), this.displayInfo.scale());
        return (T)this;
    }

    public T rotate(double xRotation, double yRotation, double zRotation) {
        this.displayInfo = new DisplayInfo(this.displayInfo.offset(), new Vec3(xRotation, yRotation, zRotation), this.displayInfo.scale());
        return (T)this;
    }

    public T scale(double scale) {
        this.displayInfo = new DisplayInfo(this.displayInfo.offset(), this.displayInfo.rotation(), scale);
        return (T)this;
    }

    public T animation(Animation.Type type, float speed) {
        this.animation = new Animation(type, speed);
        return (T)this;
    }

    public T animation(Animation.Type type) {
        return this.animation(type, 1.0f);
    }

    public T color(int baseColor, int accentColor) {
        this.colorInfo = new ColorInfo(baseColor, accentColor);
        return (T)this;
    }

    public T baseColor(int color) {
        return this.color(color, this.colorInfo.accent());
    }

    public T accentColor(int color) {
        return this.color(this.colorInfo.base(), color);
    }

    private T effectInfo(Optional<EffectInfo.SoundInfo> soundInfo, EffectInfo.RewardInfo rewardInfo) {
        this.effectInfo = new EffectInfo(soundInfo, rewardInfo);
        return (T)this;
    }

    public T sound(ResourceLocation sound, float volume, float pitch) {
        return this.effectInfo(Optional.of(new EffectInfo.SoundInfo(sound, volume, pitch)), this.effectInfo.rewards());
    }

    public T sound(ResourceLocation sound) {
        return this.sound(sound, 1.0f, 1.0f);
    }

    public T sound(SoundEvent sound, float volume, float pitch) {
        return this.sound(sound.getLocation(), volume, pitch);
    }

    public T sound(SoundEvent soundEvent) {
        return this.sound(soundEvent, 1.0f, 1.0f);
    }

    private T rewardInfo(Optional<ResourceKey<LootTable>> lootTable, Optional<EffectInfo.MobEffectInfo> mobEffect, int cooldown) {
        return this.effectInfo(this.effectInfo.sound(), new EffectInfo.RewardInfo(lootTable, mobEffect, cooldown));
    }

    public T lootTable(Optional<ResourceKey<LootTable>> lootTable) {
        return this.rewardInfo(lootTable, this.effectInfo.rewards().mobEffect(), this.effectInfo.rewards().cooldown());
    }

    public T mobEffect(EffectInfo.MobEffectInfo mobEffect) {
        return this.rewardInfo(this.effectInfo.rewards().lootTable(), Optional.of(mobEffect), this.effectInfo.rewards().cooldown());
    }

    public T mobEffect(Holder<MobEffect> effect, int timeSeconds, int amplifier) {
        return this.mobEffect(new EffectInfo.MobEffectInfo((MobEffect)effect.value(), (byte)amplifier, timeSeconds * 20, false, true, true));
    }

    public T mobEffect(Holder<MobEffect> effect, int timeSeconds) {
        return this.mobEffect(effect, timeSeconds, 0);
    }

    public T cooldown(int timeSeconds) {
        return this.rewardInfo(this.effectInfo.rewards().lootTable(), this.effectInfo.rewards().mobEffect(), timeSeconds * 20);
    }

    public T setHidden(boolean isHidden) {
        this.isHidden = isHidden;
        return (T)this;
    }

    public T setHidden() {
        return this.setHidden(true);
    }

    public JsonObject toJson() {
        JsonObject result = ((JsonElement)Trophy.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.build()).getOrThrow()).getAsJsonObject();
        ConditionsHelper.addModLoadedConditions(result, (String[])this.requiredMods.toArray(String[]::new));
        return result;
    }
}

