/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.builder;

import java.util.Optional;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import trofers.trophy.builder.TrophyBuilder;
import trofers.trophy.components.EntityInfo;

public class ItemTrophyBuilder
extends TrophyBuilder<ItemTrophyBuilder> {
    private ResourceLocation item;
    private int count = 1;
    private DataComponentMap components = DataComponentMap.EMPTY;

    public ItemTrophyBuilder setItem(ItemStack item) {
        this.setItem((ItemLike)item.getItem());
        this.setCount(item.getCount());
        this.setComponents(item.getComponents());
        return this;
    }

    public ItemTrophyBuilder setItem(ItemLike item) {
        this.item = BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        return this;
    }

    public ItemTrophyBuilder setItem(ResourceLocation itemId) {
        this.item = itemId;
        return this;
    }

    public ItemTrophyBuilder setCount(int count) {
        this.count = count;
        return this;
    }

    public ItemTrophyBuilder setComponents(DataComponentMap components) {
        this.components = components;
        return this;
    }

    @Override
    public ItemStack getDisplayItem() {
        ItemStack result = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.item));
        result.applyComponents(this.components);
        result.setCount(this.count);
        return result;
    }

    @Override
    protected Optional<EntityInfo> getEntityInfo() {
        return Optional.empty();
    }
}

