/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import trofers.data.ModCodecs;
import trofers.registry.ModDataComponents;
import trofers.registry.ModRegistries;
import trofers.trophy.builder.ItemTrophyBuilder;
import trofers.trophy.components.Animation;
import trofers.trophy.components.ColorInfo;
import trofers.trophy.components.DisplayInfo;
import trofers.trophy.components.EffectInfo;
import trofers.trophy.components.EntityInfo;

public record Trophy(Optional<Component> name, List<Component> tooltip, DisplayInfo display, Animation animation, ItemStack item, Optional<EntityInfo> entity, ColorInfo colors, EffectInfo effects, boolean isHidden) {
    public static final Trophy EMPTY = ((ItemTrophyBuilder)new ItemTrophyBuilder().setItem((ItemLike)Items.AIR).setHidden()).build();
    public static final MapCodec<Trophy> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ModCodecs.optionalField("name", ComponentSerialization.CODEC).forGetter(Trophy::name), (App)ModCodecs.defaultField("tooltip", List.of(), ModCodecs.withAlternative(ComponentSerialization.CODEC.xmap(List::of, list -> (Component)list.getFirst()), ModCodecs.list(ComponentSerialization.CODEC))).forGetter(Trophy::tooltip), (App)ModCodecs.defaultField("display", DisplayInfo.NONE, DisplayInfo.CODEC).forGetter(Trophy::display), (App)ModCodecs.defaultField("animation", Animation.STATIC, Animation.CODEC).forGetter(Trophy::animation), (App)ModCodecs.defaultField("item", ItemStack.EMPTY, ModCodecs.ITEM_STACK).forGetter(Trophy::item), (App)ModCodecs.optionalField("entity", EntityInfo.CODEC).forGetter(Trophy::entity), (App)ModCodecs.defaultField("colors", ColorInfo.NONE, ColorInfo.CODEC).forGetter(Trophy::colors), (App)ModCodecs.defaultField("effects", EffectInfo.NONE, EffectInfo.CODEC).forGetter(Trophy::effects), (App)ModCodecs.defaultField("is_hidden", false, Codec.BOOL).forGetter(Trophy::isHidden)).apply((Applicative)instance, Trophy::new));
    public static final Codec<Trophy> CODEC = MAP_CODEC.codec();

    @Nullable
    public static Trophy getTrophy(ItemStack stack) {
        return ModRegistries.get(ModRegistries.TROPHIES, (ResourceLocation)stack.get((DataComponentType)ModDataComponents.TROPHY.get()));
    }

    public static ItemStack createItem(ItemLike trophyBase, ResourceLocation id) {
        ItemStack stack = new ItemStack(trophyBase);
        stack.set((DataComponentType)ModDataComponents.TROPHY.get(), (Object)id);
        return stack;
    }
}

