/*
 * Decompiled with CFR 0.152.
 */
package trofers.registry;

import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import trofers.Trofers;
import trofers.block.TrophyBlock;
import trofers.item.TrophyItem;
import trofers.trophy.Trophy;

public class ModBlocks {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((String)"trofers", (ResourceKey)Registries.CREATIVE_MODE_TAB);
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"trofers", (ResourceKey)Registries.BLOCK);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"trofers", (ResourceKey)Registries.ITEM);
    public static final RegistrySupplier<CreativeModeTab> CREATIVE_TAB = CREATIVE_MODE_TABS.register("main", () -> CreativeTabRegistry.create((Component)Component.translatable((String)"%s.creative_tab".formatted("trofers")), ModBlocks::makeIcon));
    public static final Set<RegistrySupplier<TrophyBlock>> TROPHIES = new HashSet<RegistrySupplier<TrophyBlock>>();
    public static final RegistrySupplier<TrophyBlock> SMALL_PILLAR = ModBlocks.addPillar("small_pillar", 6);
    public static final RegistrySupplier<TrophyBlock> MEDIUM_PILLAR = ModBlocks.addPillar("medium_pillar", 7);
    public static final RegistrySupplier<TrophyBlock> LARGE_PILLAR = ModBlocks.addPillar("large_pillar", 8);
    public static final RegistrySupplier<TrophyBlock> SMALL_PLATE = ModBlocks.addPlate("small_plate", 6);
    public static final RegistrySupplier<TrophyBlock> MEDIUM_PLATE = ModBlocks.addPlate("medium_plate", 7);
    public static final RegistrySupplier<TrophyBlock> LARGE_PLATE = ModBlocks.addPlate("large_plate", 8);

    private static RegistrySupplier<TrophyBlock> addPillar(String name, int size) {
        return ModBlocks.addTrophy(name, () -> TrophyBlock.createPillarTrophy(ModBlocks.createProperties(), size));
    }

    private static RegistrySupplier<TrophyBlock> addPlate(String name, int size) {
        return ModBlocks.addTrophy(name, () -> TrophyBlock.createPlateTrophy(ModBlocks.createProperties(), size));
    }

    private static RegistrySupplier<TrophyBlock> addTrophy(String name, Supplier<TrophyBlock> block) {
        RegistrySupplier trophy = BLOCKS.register(name, block);
        ITEMS.register(name, () -> new TrophyItem((TrophyBlock)((Object)((Object)trophy.get())), new Item.Properties().fireResistant().arch$tab(CREATIVE_TAB)));
        TROPHIES.add((RegistrySupplier<TrophyBlock>)trophy);
        return trophy;
    }

    private static BlockBehaviour.Properties createProperties() {
        return BlockBehaviour.Properties.of().mapColor(DyeColor.WHITE).strength(1.5f);
    }

    private static ItemStack makeIcon() {
        return Trophy.createItem((ItemLike)MEDIUM_PILLAR.get(), Trofers.id("panda"));
    }
}

