/*
 * Decompiled with CFR 0.152.
 */
package trofers.neoforge.datagen.providers;

import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import trofers.block.TrophyBlock;
import trofers.registry.ModBlocks;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "trofers", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.createPillar((TrophyBlock)((Object)ModBlocks.SMALL_PILLAR.get()), 6);
        this.createPillar((TrophyBlock)((Object)ModBlocks.MEDIUM_PILLAR.get()), 7);
        this.createPillar((TrophyBlock)((Object)ModBlocks.LARGE_PILLAR.get()), 8);
        this.createPlate((TrophyBlock)((Object)ModBlocks.SMALL_PLATE.get()), 6);
        this.createPlate((TrophyBlock)((Object)ModBlocks.MEDIUM_PLATE.get()), 7);
        this.createPlate((TrophyBlock)((Object)ModBlocks.LARGE_PLATE.get()), 8);
    }

    private ModelBuilder<?> createBuilder(TrophyBlock block) {
        String modelLocation = "trofers:block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder builder = this.models().withExistingParent(modelLocation, "block");
        this.horizontalBlock((Block)block, state -> builder);
        return builder;
    }

    private void createPillar(TrophyBlock block, int size) {
        ModelBuilder<?> builder = this.createBuilder(block);
        int width = 2 * (size - 2);
        BlockStates.texturedCenteredBox(builder, width, 0, 2, 0);
        BlockStates.texturedCenteredBox(builder, width - 2, 2, size - 2, 1);
        BlockStates.texturedCenteredBox(builder, width, size - 2, size, 0);
        BlockStates.setTextures(builder, block);
    }

    private void createPlate(TrophyBlock block, int size) {
        ModelBuilder<?> builder = this.createBuilder(block);
        int width = 2 * (size - 2);
        BlockStates.texturedCenteredBox(builder, width, 0, 2, 0);
        BlockStates.centeredBox(builder, width, 0, 2).face(Direction.UP).tintindex(1).texture("#overlay");
        BlockStates.setTextures(builder, block);
        String overlayTexture = "trofers:block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + "_overlay";
        builder.texture("overlay", overlayTexture);
        builder.renderType("cutout");
    }

    private static void setTextures(ModelBuilder<?> modelBuilder, TrophyBlock block) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        String texturePath = "trofers:block/" + name.replace("plate", "pillar");
        modelBuilder.texture("particle", "#top").texture("top", texturePath + "_top").texture("side", texturePath + "_side");
    }

    private static void texturedCenteredBox(ModelBuilder<?> builder, int width, int minY, int maxY, int tintIndex) {
        BlockStates.centeredBox(builder, width, minY, maxY).allFaces((direction, face) -> face.tintindex(tintIndex).texture(direction.getAxis() == Direction.Axis.Y ? "#top" : "#side"));
    }

    private static ModelBuilder.ElementBuilder centeredBox(ModelBuilder<?> builder, int width, int minY, int maxY) {
        return builder.element().from(8.0f - (float)width / 2.0f, (float)minY, 8.0f - (float)width / 2.0f).to(8.0f + (float)width / 2.0f, (float)maxY, 8.0f + (float)width / 2.0f);
    }
}

