/*
 * Decompiled with CFR 0.152.
 */
package trofers.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import trofers.block.entity.TrophyBlockEntity;
import trofers.trophy.Trophy;
import trofers.trophy.components.Animation;
import trofers.trophy.components.EntityInfo;

public class TrophyBlockEntityRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    public TrophyBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRenderOffScreen(TrophyBlockEntity blockEntity) {
        return true;
    }

    public void render(TrophyBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        Direction direction = ((Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
        poseStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
        Trophy trophy = blockEntity.getTrophy();
        if (trophy != null && Minecraft.getInstance().player != null) {
            float ticks = (float)Minecraft.getInstance().player.tickCount + partialTicks + blockEntity.getAnimationOffset();
            TrophyBlockEntityRenderer.render(trophy, ticks, blockEntity.getTrophyHeight(), poseStack, multiBufferSource, light, overlay);
        }
        poseStack.popPose();
    }

    public static void render(Trophy trophy, float ticks, int trophyHeight, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        TrophyBlockEntityRenderer.renderItem(trophy, ticks, trophyHeight, poseStack, multiBufferSource, light, overlay);
        TrophyBlockEntityRenderer.renderEntity(trophy, ticks, trophyHeight, poseStack, multiBufferSource, light);
    }

    private static void renderItem(Trophy trophy, float ticks, int trophyHeight, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        poseStack.pushPose();
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        BakedModel model = renderer.getModel(trophy.item(), (Level)Minecraft.getInstance().level, null, 0);
        float yOffset = 0.25f;
        TrophyBlockEntityRenderer.applyDisplayTransforms(poseStack, trophy, trophyHeight, yOffset, ticks);
        poseStack.translate(0.0, 0.25, 0.0);
        if (!model.isGui3d()) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
        }
        Minecraft.getInstance().getItemRenderer().renderStatic(trophy.item(), ItemDisplayContext.FIXED, light, overlay, poseStack, multiBufferSource, (Level)Minecraft.getInstance().level, 0);
        poseStack.popPose();
    }

    private static void renderEntity(Trophy trophy, float ticks, int trophyHeight, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        if (Minecraft.getInstance().level == null || trophy.entity().isEmpty()) {
            return;
        }
        EntityInfo entityInfo = trophy.entity().get();
        Entity entity = entityInfo.getOrCreateEntity((Level)Minecraft.getInstance().level);
        if (entity == null) {
            return;
        }
        poseStack.pushPose();
        float entityHeight = entity.getBbHeight();
        TrophyBlockEntityRenderer.applyDisplayTransforms(poseStack, trophy, trophyHeight, entityHeight / 2.0f, ticks);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        Minecraft.getInstance().getEntityRenderDispatcher().render(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, light);
        poseStack.popPose();
    }

    private static void applyDisplayTransforms(PoseStack poseStack, Trophy trophy, int trophyHeight, float yRotationOffset, float ticks) {
        yRotationOffset = (float)((double)yRotationOffset * trophy.display().scale());
        float animationProgress = 6.0f * ticks * (float)trophy.animation().speed();
        poseStack.translate(0.0, ((double)trophyHeight + trophy.display().offset().y()) / 16.0, 0.0);
        poseStack.translate(0.0f, yRotationOffset, 0.0f);
        if (trophy.animation().type() == Animation.Type.SPINNING) {
            poseStack.mulPose(Axis.YP.rotationDegrees(animationProgress));
        } else if (trophy.animation().type() == Animation.Type.TUMBLING) {
            poseStack.mulPose(Axis.YP.rotationDegrees(animationProgress));
            poseStack.mulPose(Axis.XP.rotationDegrees(animationProgress * 0.8f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(animationProgress * 0.6f));
        }
        poseStack.translate(0.0f, -yRotationOffset, 0.0f);
        poseStack.translate(trophy.display().offset().x() / 16.0, 0.0, 0.0);
        poseStack.translate(0.0, 0.0, trophy.display().offset().z() / 16.0);
        poseStack.mulPose(Axis.XP.rotationDegrees((float)trophy.display().rotation().x()));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)trophy.display().rotation().y()));
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)trophy.display().rotation().z()));
        float scale = (float)trophy.display().scale();
        poseStack.scale(scale, scale, scale);
    }
}

