/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import com.google.common.base.Preconditions;
import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTargets;
import dev.technici4n.moderndynamics.network.item.StartTravelCallback;
import dev.technici4n.moderndynamics.util.ItemVariant;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class SimulatedInsertionTarget {
    private final SimulatedInsertionTargets.Coord coord;
    private final Supplier<@Nullable IItemHandler> storageFinder;
    private final Object2IntMap<ItemVariant> pendingStacks = new Object2IntLinkedOpenHashMap();
    private final List<ItemStack> awaitedStacks = new ArrayList<ItemStack>();

    public SimulatedInsertionTarget(SimulatedInsertionTargets.Coord coord, Supplier<@Nullable IItemHandler> storageFinder) {
        this.coord = coord;
        this.storageFinder = storageFinder;
    }

    public boolean hasStorage() {
        return this.storageFinder.get() != null;
    }

    public int insert(ItemVariant variant, int maxAmount, boolean simulate, StartTravelCallback callback) {
        try {
            return this.innerInsert(variant, maxAmount, simulate, callback);
        }
        catch (Throwable t) {
            CrashReport report = CrashReport.forThrowable((Throwable)t, (String)"Item pipe simulated insertion failed");
            CrashReportCategory target = report.addCategory("Simulated insertion details");
            CrashReportCategory.populateBlockDetails((CrashReportCategory)target, (LevelHeightAccessor)this.coord.world(), (BlockPos)this.coord.pos(), (BlockState)this.coord.world().getBlockState(this.coord.pos()));
            target.setDetail("Accessed from side", (Object)this.coord.direction());
            target.setDetail("Storage", () -> Objects.toString(this.storageFinder.get(), null)).setDetail("Item variant", (Object)variant).setDetail("Max amount", (Object)maxAmount).setDetail("Simulate", (Object)simulate);
            throw new ReportedException(report);
        }
    }

    private int innerInsert(ItemVariant variant, int maxAmount, boolean simulate, StartTravelCallback callback) {
        Preconditions.checkArgument((!variant.isBlank() ? 1 : 0) != 0, (Object)"blank variant");
        Preconditions.checkArgument((maxAmount >= 0 ? 1 : 0) != 0, (Object)"non-negative amount");
        IItemHandler targetStorage = this.storageFinder.get();
        if (targetStorage == null) {
            return 0;
        }
        ObjectIterator pendingIterator = this.pendingStacks.object2IntEntrySet().iterator();
        while (pendingIterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)pendingIterator.next();
            int planned = this.planForStack(targetStorage, (ItemVariant)entry.getKey(), entry.getIntValue(), false);
            if (planned == entry.getIntValue()) {
                pendingIterator.remove();
                continue;
            }
            entry.setValue(entry.getIntValue() - planned);
        }
        int inserted = this.planForStack(targetStorage, variant, maxAmount, simulate);
        if (!simulate && inserted > 0) {
            callback.startTravel(variant, inserted);
        }
        return inserted;
    }

    private int planForStack(IItemHandler targetStorage, ItemVariant variant, int maxAmount, boolean simulate) {
        int targetSlots = targetStorage.getSlots();
        while (this.awaitedStacks.size() < targetSlots) {
            this.awaitedStacks.add(ItemStack.EMPTY);
        }
        ItemStack leftover = null;
        for (int i = 0; i < targetSlots; ++i) {
            ItemStack pending = this.awaitedStacks.get(i);
            if (pending.isEmpty()) {
                int toInsert;
                if (leftover == null) {
                    leftover = variant.toStack(maxAmount);
                }
                if ((inserted = (toInsert = leftover.getCount()) - (leftover = targetStorage.insertItem(i, leftover, true)).getCount()) > 0 && !simulate) {
                    this.awaitedStacks.set(i, variant.toStack(inserted));
                }
            } else if (variant.matches(pending)) {
                int insertCount;
                int delta;
                if (leftover == null) {
                    leftover = variant.toStack(maxAmount);
                }
                if ((delta = (inserted = (insertCount = pending.getCount() + leftover.getCount()) - targetStorage.insertItem(i, variant.toStack(insertCount), true).getCount()) - pending.getCount()) > 0) {
                    leftover.shrink(delta);
                    if (!simulate) {
                        pending.grow(delta);
                    }
                }
            }
            if (leftover != null && leftover.isEmpty()) break;
        }
        return leftover == null ? 0 : maxAmount - leftover.getCount();
    }

    public void startAwaiting(ItemVariant variant, int amount) {
        this.pendingStacks.mergeInt((Object)variant, amount, Integer::sum);
    }

    public void stopAwaiting(ItemVariant variant, int amount) {
        int pending = this.pendingStacks.getInt((Object)variant);
        if (pending > 0) {
            if (pending >= amount) {
                this.pendingStacks.put((Object)variant, pending - amount);
                amount = 0;
            } else {
                this.pendingStacks.removeInt((Object)variant);
                amount -= pending;
            }
        }
        if (amount > 0) {
            int slot = this.awaitedStacks.size();
            while (slot-- > 0) {
                ItemStack awaited = this.awaitedStacks.get(slot);
                if (!variant.matches(awaited)) continue;
                if (awaited.getCount() > amount) {
                    awaited.shrink(amount);
                    amount = 0;
                } else {
                    this.awaitedStacks.set(slot, ItemStack.EMPTY);
                    amount -= awaited.getCount();
                }
                if (amount != 0) continue;
                break;
            }
        }
    }
}

