/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

record UpgradeRecipe(Item item, UpgradeType upgradeInfo) implements EmiRecipe
{
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(MdId.of("upgrades"), (EmiRenderable)EmiStack.of((ItemLike)MdItems.EXTRACTOR)){

        public Component getName() {
            return Component.translatable((String)"gui.moderndynamics.rei.upgrade_category");
        }
    };

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)this.item);
        return MdId.of("upgrades/" + itemId.getNamespace() + "/" + itemId.getPath());
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of((ItemLike)this.item));
    }

    public List<EmiStack> getOutputs() {
        return List.of();
    }

    public int getDisplayWidth() {
        return 134;
    }

    public int getDisplayHeight() {
        return 59;
    }

    public void addWidgets(WidgetHolder widgets) {
        UpgradeType type = this.upgradeInfo;
        ResourceLocation texture = MdId.of("textures/gui/icons.png");
        int baseY = 37;
        int countXOffset = 17;
        int countY = 50;
        int effectWidth = 23;
        int effectSpacing = 5;
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)this.item), 2, 2);
        widgets.addText(Component.translatable((String)"gui.moderndynamics.tooltip.upgrades_max", (Object[])new Object[]{type.getSlotLimit()}).getVisualOrderText(), 25, 7, -12566464, false);
        widgets.addText(Component.translatable((String)"gui.moderndynamics.tooltip.upgrades_effects").setStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true))).getVisualOrderText(), this.getDisplayWidth() / 2, 23, -12566464, false).horizontalAlign(TextWidget.Alignment.CENTER);
        ArrayList<UpgradeEffect> effects = new ArrayList<UpgradeEffect>();
        effects.add(new UpgradeEffect(0, type.isEnableAdvancedBehavior() ? -1 : 0, "enableAdvancedBehavior", I18n.get((String)"gui.moderndynamics.tooltip.advanced_behavior_available", (Object[])new Object[0])));
        effects.add(new UpgradeEffect(16, type.getAddFilterSlots(), "addFilterSlots", "+" + type.getAddFilterSlots()));
        effects.add(new UpgradeEffect(32, type.getAddItemCount(), "addItemCount", "+" + type.getAddItemCount()));
        effects.add(new UpgradeEffect(48, type.getAddItemSpeed(), "addItemSpeed", "+" + type.getAddItemSpeed() * 100 + "%"));
        effects.add(new UpgradeEffect(64, type.getAddItemTransferFrequency(), "addItemTransferFrequency", "+" + type.getAddItemTransferFrequency() * 100 + "%"));
        effects.add(new UpgradeEffect(80, type.getAddFluidTransfer(), "addFluidTransfer", "+" + type.getAddFluidTransfer() * 100 + "%"));
        effects.add(new UpgradeEffect(96, type.getMultiplyFluidTransfer(), "multiplyFluidTransfer", "+" + type.getMultiplyFluidTransfer() * 100 + "%"));
        effects.removeIf(e -> e.count() == 0);
        if (effects.size() > 0) {
            int totalWidth = effects.size() * effectWidth + (effects.size() - 1) * effectSpacing;
            int baseX = (this.getDisplayWidth() - totalWidth) / 2;
            for (UpgradeEffect e2 : effects) {
                Style greenStyle = Style.EMPTY.applyFormat(ChatFormatting.GREEN);
                MutableComponent tooltip = Component.translatable((String)("gui.moderndynamics.tooltip.upgrade_" + e2.upgradeName()), (Object[])new Object[]{Component.literal((String)e2.greenText).setStyle(greenStyle)});
                widgets.addTexture(texture, baseX, baseY, 16, 16, e2.textureU(), 0);
                String renderedString = e2.count() > 0 ? "" + e2.count() : "";
                widgets.addText(Component.literal((String)renderedString).getVisualOrderText(), baseX + countXOffset, countY, -12566464, false).horizontalAlign(TextWidget.Alignment.CENTER);
                widgets.addDrawable(baseX, baseY, 20, 20, (matrices, mouseX, mouseY, delta) -> {}).tooltip((mouseX, mouseY) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)tooltip.getVisualOrderText())));
                baseX += effectWidth + effectSpacing;
            }
        }
    }

    private record UpgradeEffect(int textureU, int count, String upgradeName, String greenText) {
    }
}

