/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.utils;

import com.mrbysco.instrumentalmobs.Constants;
import com.mrbysco.instrumentalmobs.entities.IInstrumentalMobs;
import com.mrbysco.instrumentalmobs.platform.Services;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class InstrumentHelper {
    public static void instrumentDamage(LivingEntity livingEntity) {
        InstrumentHelper.instrumentDamage(livingEntity.level(), livingEntity, livingEntity.getBoundingBox().inflate(Services.PLATFORM.instrumentRange()));
    }

    public static void instrumentDamage(Level level, LivingEntity livingEntity, AABB box) {
        if (!level.isClientSide && livingEntity != null) {
            List<LivingEntity> livingEntities = level.getEntities((Entity)livingEntity, box).stream().filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).toList();
            for (LivingEntity collidingEntity : livingEntities) {
                double xDist = collidingEntity.getX() - livingEntity.getX() + level.random.nextDouble() - level.random.nextDouble();
                double zDist = collidingEntity.getZ() - livingEntity.getZ() + level.random.nextDouble() - level.random.nextDouble();
                double distance = Math.sqrt(xDist * xDist + zDist * zDist);
                collidingEntity.hurtMarked = true;
                collidingEntity.push(0.5 * xDist / distance, 5.0 / (10.0 + distance), 0.5 * zDist / distance);
                if (!(level.random.nextDouble() <= Services.PLATFORM.soundDamageChance())) continue;
                if (livingEntity instanceof Player) {
                    double chance = Services.PLATFORM.instrumentHurtChance();
                    if (collidingEntity instanceof Player) {
                        Player playerIn = (Player)livingEntity;
                        Player collidingPlayer = (Player)collidingEntity;
                        if (!playerIn.canHarmPlayer(collidingPlayer) || !(level.random.nextDouble() <= chance)) continue;
                        collidingEntity.hurt(Constants.causeSoundDamage((Entity)livingEntity), 1.0f);
                        continue;
                    }
                    if (collidingEntity.getType().getCategory() == MobCategory.MONSTER || !(level.random.nextDouble() <= chance)) continue;
                    collidingEntity.hurt(Constants.causeSoundDamage((Entity)livingEntity), 1.0f);
                    continue;
                }
                if ((collidingEntity.getType().getCategory() != MobCategory.MONSTER || collidingEntity instanceof IInstrumentalMobs) && !(collidingEntity instanceof Player)) continue;
                collidingEntity.hurt(Constants.causeSoundDamage((Entity)livingEntity), 1.0f);
            }
        }
    }
}

