/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.platform;

import com.mrbysco.instrumentalmobs.config.InstrumentalConfigForge;
import com.mrbysco.instrumentalmobs.platform.services.IPlatformHelper;
import com.mrbysco.instrumentalmobs.registration.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.registration.RegistryObject;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.event.EventHooks;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public CreativeModeTab buildCreativeTab() {
        return CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)Blocks.NOTE_BLOCK)).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).title((Component)Component.translatable((String)"itemGroup.instrumentalmobs")).displayItems((displayParameters, output) -> {
            List<ItemStack> stacks = InstrumentalRegistry.ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
            output.acceptAll(stacks);
        }).build();
    }

    @Override
    public <T extends Mob> SpawnEggItem buildSpawnEgg(RegistryObject<EntityType<T>> type, int backgroundColor, int highlightColor, Item.Properties props) {
        return new DeferredSpawnEggItem(type, backgroundColor, highlightColor, props);
    }

    @Override
    public Level.ExplosionInteraction getExplosionInteraction(Entity entity) {
        return EventHooks.canEntityGrief((Level)entity.level(), (Entity)entity) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
    }

    @Override
    public boolean isEnderMask(ItemStack stack, Player player, EnderMan enderMan) {
        return stack.isEnderMask(player, enderMan);
    }

    @Override
    public boolean mobsReact() {
        return (Boolean)InstrumentalConfigForge.COMMON.mobsReact.get();
    }

    @Override
    public double instrumentRange() {
        return (Double)InstrumentalConfigForge.COMMON.instrumentRange.get();
    }

    @Override
    public double soundDamageChance() {
        return (Double)InstrumentalConfigForge.COMMON.soundDamageChance.get();
    }

    @Override
    public double instrumentDropChance() {
        return (Double)InstrumentalConfigForge.COMMON.instrumentDropChance.get();
    }

    @Override
    public double instrumentHurtChance() {
        return (Double)InstrumentalConfigForge.COMMON.instrumentHurtChance.get();
    }
}

