/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.modifier;

import com.mojang.serialization.MapCodec;
import com.mrbysco.instrumentalmobs.init.InstrumentalModifiers;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record AddRelativeSpawnBiomeModifier(EntityType<?> originalType, EntityType<?> newType, int relativeWeight) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            MobSpawnSettings info = ((Biome)biome.value()).getMobSettings();
            List spawnsList = spawns.getSpawner(MobCategory.MONSTER);
            for (MobSpawnSettings.SpawnerData entry : info.getMobs(MobCategory.MONSTER).unwrap()) {
                if (entry.type != this.originalType) continue;
                spawnsList.add(new MobSpawnSettings.SpawnerData(this.newType, Math.min(1, entry.getWeight().asInt() / this.relativeWeight), entry.minCount, entry.maxCount));
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return InstrumentalModifiers.ADD_RELATIVE_MOB_SPAWNS.get();
    }
}

