/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.items;

import com.mrbysco.instrumentalmobs.entities.projectiles.MicrophoneWave;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class InstrumentMicrophone
extends Item {
    private final Supplier<? extends SoundEvent> sound;
    private final int cooldown;
    private final int useDuration;

    public InstrumentMicrophone(Item.Properties properties, Supplier<? extends SoundEvent> soundIn, int cooldown, int duration) {
        super(properties);
        this.cooldown = cooldown;
        this.sound = soundIn;
        this.useDuration = duration;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.cooldown != 0) {
            player.getCooldowns().addCooldown((Item)this, this.cooldown);
        }
        if (!level.isClientSide) {
            MicrophoneWave soundWave = new MicrophoneWave(level, (LivingEntity)player, this.sound.get());
            soundWave.shoot(player.getXRot(), player.getYRot(), 0.0, 2.0f, 0.0f);
            soundWave.setOwner((Entity)player);
            level.addFreshEntity((Entity)soundWave);
        }
        stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return this.useDuration;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }
}

