/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities.projectiles;

import com.mrbysco.instrumentalmobs.Constants;
import com.mrbysco.instrumentalmobs.platform.Services;
import com.mrbysco.instrumentalmobs.registration.InstrumentalEntities;
import com.mrbysco.instrumentalmobs.registration.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.utils.InstrumentHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SoundWaves
extends AbstractHurtingProjectile
implements ItemSupplier {
    private SoundEvent sound = SoundEvents.GHAST_SCREAM;

    public SoundWaves(EntityType<? extends SoundWaves> type, Level level) {
        super(type, level);
    }

    public SoundWaves(Level level, double x, double y, double z, Vec3 movement) {
        super(InstrumentalEntities.SOUND_WAVE.get(), x, y, z, movement, level);
    }

    public SoundWaves(Level level, LivingEntity shooter, Vec3 movement) {
        super(InstrumentalEntities.SOUND_WAVE.get(), shooter, movement, level);
    }

    public SoundWaves(Level level, LivingEntity shooter, SoundEvent theSound) {
        super(InstrumentalEntities.SOUND_WAVE.get(), shooter, new Vec3(1.0, 1.0, 1.0), level);
        this.sound = theSound;
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.soundExplosion();
            this.removeAfterChangingDimensions();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onHitEntity(EntityHitResult result) {
        boolean wasHurt;
        Entity entity = result.getEntity();
        DamageSource source = Constants.causeSoundDamage((Entity)this);
        if (entity instanceof Player) {
            Player collidingPlayer = (Player)entity;
            Entity entity2 = this.getOwner();
            if (entity2 instanceof Player) {
                Player playerIn = (Player)entity2;
                if (!playerIn.canHarmPlayer(collidingPlayer)) return;
                if (this.level().random.nextInt(10) > 2) return;
                collidingPlayer.hurt(source, 1.0f);
                return;
            }
        }
        if (!(wasHurt = entity.hurt(Constants.causeSoundDamage((Entity)this), 6.0f))) return;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) return;
        ServerLevel serverlevel1 = (ServerLevel)level;
        EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)entity, (DamageSource)source, (ItemStack)this.getWeaponItem());
    }

    public void soundExplosion() {
        this.level().playSound(null, this.blockPosition(), this.sound, this.getSoundSource(), 1.0f, this.level().random.nextFloat() * 0.1f + 0.9f);
        this.level().addParticle((ParticleOptions)ParticleTypes.NOTE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        if (Services.PLATFORM.mobsReact() && this.getOwner() instanceof LivingEntity) {
            InstrumentHelper.instrumentDamage(this.level(), (LivingEntity)this.getOwner(), this.getBoundingBox().inflate(Services.PLATFORM.instrumentRange()));
        }
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec3 = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(vec3);
        double d0 = vec3.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)InstrumentalRegistry.MICROPHONE.get());
    }
}

