/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities.projectiles;

import com.mrbysco.instrumentalmobs.Constants;
import com.mrbysco.instrumentalmobs.platform.Services;
import com.mrbysco.instrumentalmobs.registration.InstrumentalEntities;
import com.mrbysco.instrumentalmobs.registration.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.utils.InstrumentHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class MicrophoneWave
extends ThrowableItemProjectile {
    private SoundEvent sound = SoundEvents.GHAST_SCREAM;
    private LivingEntity shootingEntity;

    public MicrophoneWave(EntityType<? extends MicrophoneWave> type, Level level) {
        super(type, level);
    }

    public MicrophoneWave(Level level, LivingEntity throwerIn, SoundEvent theSound) {
        super(InstrumentalEntities.MICROPHONE_WAVE.get(), throwerIn, level);
        this.shootingEntity = throwerIn;
        this.sound = theSound;
    }

    public MicrophoneWave(Level level, double x, double y, double z) {
        super(InstrumentalEntities.MICROPHONE_WAVE.get(), x, y, z, level);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.soundExplosion();
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onHitEntity(EntityHitResult result) {
        boolean wasHurt;
        Entity entity = result.getEntity();
        DamageSource source = Constants.causeSoundDamage((Entity)this);
        if (entity instanceof Player) {
            Player collidingPlayer = (Player)entity;
            LivingEntity livingEntity = this.shootingEntity;
            if (livingEntity instanceof Player) {
                Player playerIn = (Player)livingEntity;
                if (!playerIn.canHarmPlayer(collidingPlayer)) return;
                if (this.level().random.nextInt(10) > 2) return;
                collidingPlayer.hurt(source, 1.0f);
                return;
            }
        }
        if (!(wasHurt = entity.hurt(Constants.causeSoundDamage((Entity)this), 6.0f))) return;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) return;
        ServerLevel serverlevel1 = (ServerLevel)level;
        EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)entity, (DamageSource)source, (ItemStack)this.getWeaponItem());
    }

    public void soundExplosion() {
        this.level().playSound(null, this.blockPosition(), this.sound, this.getSoundSource(), 1.0f, this.level().random.nextFloat() * 0.1f + 0.9f);
        this.level().addParticle((ParticleOptions)ParticleTypes.NOTE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        if (Services.PLATFORM.mobsReact()) {
            InstrumentHelper.instrumentDamage(this.level(), (LivingEntity)this.getOwner(), this.getBoundingBox().inflate(Services.PLATFORM.instrumentRange()));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    protected Item getDefaultItem() {
        return InstrumentalRegistry.MICROPHONE.get();
    }
}

