/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities;

import com.mrbysco.instrumentalmobs.entities.IInstrumentalMobs;
import com.mrbysco.instrumentalmobs.entities.IInstrumentalSkeleton;
import com.mrbysco.instrumentalmobs.entities.goals.SkeletonInstrumentAttackGoal;
import com.mrbysco.instrumentalmobs.registration.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.registration.InstrumentalSounds;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class XylophoneSkeleton
extends Skeleton
implements IInstrumentalMobs,
IInstrumentalSkeleton {
    private static final EntityDataAccessor<Boolean> PLAYING_RIBS = SynchedEntityData.defineId(XylophoneSkeleton.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public XylophoneSkeleton(EntityType<? extends XylophoneSkeleton> type, Level level) {
        super(type, level);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(4, new SkeletonInstrumentAttackGoal<XylophoneSkeleton>(this, 1.2, false, InstrumentalSounds.XYLOPHONE_SOUND::get));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.BABY_ON_LAND_SELECTOR));
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHit) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHit);
        if (this.getDropChance() <= this.random.nextFloat()) {
            this.spawnAtLocation((ItemLike)InstrumentalRegistry.XYLOPHONE.get());
        }
    }

    public void reassessWeaponGoal() {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PLAYING_RIBS, (Object)Boolean.FALSE);
    }

    @Override
    public void setPlayingInstrument(boolean armsRaised) {
        this.getEntityData().set(PLAYING_RIBS, (Object)armsRaised);
    }

    @Override
    public boolean isPlayingInstrument() {
        return (Boolean)this.getEntityData().get(PLAYING_RIBS);
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance instance) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BONE));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.BONE));
        this.setDropChance(EquipmentSlot.MAINHAND, this.getDropChance());
        this.setDropChance(EquipmentSlot.OFFHAND, this.getDropChance());
    }
}

