/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities;

import com.mrbysco.instrumentalmobs.entities.IInstrumentalMobs;
import com.mrbysco.instrumentalmobs.entities.projectiles.SoundWaves;
import com.mrbysco.instrumentalmobs.registration.InstrumentalRegistry;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MicrophoneGhast
extends Ghast
implements IInstrumentalMobs {
    private static final EntityDataAccessor<Boolean> SINGING = SynchedEntityData.defineId(MicrophoneGhast.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public MicrophoneGhast(EntityType<? extends MicrophoneGhast> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(5, (Goal)new RandomFlyGoal(this));
        this.goalSelector.addGoal(7, (Goal)new LookAroundGoal(this));
        this.goalSelector.addGoal(7, (Goal)new VoiceAttackGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, livingEntity -> Math.abs(livingEntity.getY() - this.getY()) <= 4.0));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SINGING, (Object)false);
    }

    public void setSinging(boolean isSinging) {
        this.getEntityData().set(SINGING, (Object)isSinging);
    }

    public boolean isSinging() {
        return (Boolean)this.getEntityData().get(SINGING);
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)InstrumentalRegistry.MICROPHONE.get()));
        this.setDropChance(EquipmentSlot.HEAD, this.getDropChance());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        RandomSource randomSource = serverLevelAccessor.getRandom();
        spawnGroupData = super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
        this.populateDefaultEquipmentSlots(randomSource, difficultyInstance);
        return spawnGroupData;
    }

    public static boolean canSpawnHere(EntityType<MicrophoneGhast> p_223368_0_, LevelAccessor p_223368_1_, MobSpawnType reason, BlockPos p_223368_3_, RandomSource p_223368_4_) {
        return p_223368_1_.getDifficulty() != Difficulty.PEACEFUL && p_223368_4_.nextInt(20) == 0 && MicrophoneGhast.checkMobSpawnRules(p_223368_0_, (LevelAccessor)p_223368_1_, (MobSpawnType)reason, (BlockPos)p_223368_3_, (RandomSource)p_223368_4_);
    }

    static class RandomFlyGoal
    extends Goal {
        private final MicrophoneGhast parentEntity;

        public RandomFlyGoal(MicrophoneGhast ghast) {
            this.parentEntity = ghast;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            double d2;
            double d1;
            MoveControl movementcontroller = this.parentEntity.getMoveControl();
            if (!movementcontroller.hasWanted()) {
                return true;
            }
            double d0 = movementcontroller.getWantedX() - this.parentEntity.getX();
            double d3 = d0 * d0 + (d1 = movementcontroller.getWantedY() - this.parentEntity.getY()) * d1 + (d2 = movementcontroller.getWantedZ() - this.parentEntity.getZ()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            RandomSource random = this.parentEntity.getRandom();
            double d0 = this.parentEntity.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.getMoveControl().setWantedPosition(d0, d1, d2, 1.0);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final MicrophoneGhast ghast;

        public LookAroundGoal(MicrophoneGhast ghast) {
            this.ghast = ghast;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            if (this.ghast.getTarget() == null) {
                Vec3 vec3 = this.ghast.getDeltaMovement();
                this.ghast.setYRot(-((float)Mth.atan2((double)vec3.x, (double)vec3.z)) * 57.295776f);
                this.ghast.yBodyRot = this.ghast.getYRot();
            } else {
                LivingEntity livingentity = this.ghast.getTarget();
                double d0 = 64.0;
                if (livingentity.distanceToSqr((Entity)this.ghast) < 4096.0) {
                    double d1 = livingentity.getX() - this.ghast.getX();
                    double d2 = livingentity.getZ() - this.ghast.getZ();
                    this.ghast.setYRot(-((float)Mth.atan2((double)d1, (double)d2)) * 57.295776f);
                    this.ghast.yBodyRot = this.ghast.getYRot();
                }
            }
        }
    }

    static class VoiceAttackGoal
    extends Goal {
        private final MicrophoneGhast parentEntity;
        public int attackTimer;

        public VoiceAttackGoal(MicrophoneGhast ghast) {
            this.parentEntity = ghast;
        }

        public boolean canUse() {
            return this.parentEntity.getTarget() != null;
        }

        public void start() {
            this.attackTimer = 0;
            this.parentEntity.setSinging(true);
        }

        public void stop() {
            this.parentEntity.setCharging(false);
            this.parentEntity.setSinging(false);
        }

        public void tick() {
            LivingEntity livingentity = this.parentEntity.getTarget();
            double d0 = 64.0;
            if (livingentity.distanceToSqr((Entity)this.parentEntity) < 4096.0 && this.parentEntity.hasLineOfSight((Entity)livingentity)) {
                Level world = this.parentEntity.level();
                ++this.attackTimer;
                if (this.attackTimer == 10 && !this.parentEntity.isSilent()) {
                    world.levelEvent((Player)null, 1015, this.parentEntity.blockPosition(), 0);
                }
                if (this.attackTimer == 20) {
                    double d1 = 4.0;
                    Vec3 vector3d = this.parentEntity.getViewVector(1.0f);
                    double d2 = livingentity.getX() - (this.parentEntity.getX() + vector3d.x * 4.0);
                    double d3 = livingentity.getY(0.5) - (0.5 + this.parentEntity.getY(0.5));
                    double d4 = livingentity.getZ() - (this.parentEntity.getZ() + vector3d.z * 4.0);
                    if (!this.parentEntity.isSilent()) {
                        world.levelEvent((Player)null, 1016, this.parentEntity.blockPosition(), 0);
                    }
                    SoundWaves soundWaves = new SoundWaves(world, (LivingEntity)this.parentEntity, new Vec3(d2, d3, d4));
                    soundWaves.setPos(this.parentEntity.getX() + vector3d.x * 4.0, this.parentEntity.getY(0.5) + 0.5, soundWaves.getZ() + vector3d.z * 4.0);
                    world.addFreshEntity((Entity)soundWaves);
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.setCharging(this.attackTimer > 10);
        }
    }
}

