/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities;

import com.mrbysco.instrumentalmobs.entities.IInstrumentalMobs;
import com.mrbysco.instrumentalmobs.entities.goals.InstrumentAttackGoal;
import com.mrbysco.instrumentalmobs.registration.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.registration.InstrumentalSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MaracaSpider
extends Spider
implements IInstrumentalMobs {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(MaracaSpider.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public MaracaSpider(EntityType<? extends MaracaSpider> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(4, (Goal)new SpiderInstrumentAttack(this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new TargetGoal<Player>(this, Player.class));
        this.targetSelector.addGoal(3, new TargetGoal<IronGolem>(this, IronGolem.class));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACKING, (Object)false);
    }

    public void setAttacking(boolean isAttacking) {
        this.getEntityData().set(ATTACKING, (Object)isAttacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.getEntityData().get(ATTACKING);
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SoundEvents.SPIDER_STEP, 0.15f, 1.0f);
        this.playSound(InstrumentalSounds.MARACA_SOUND.get(), 0.15f, 1.0f);
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)InstrumentalRegistry.MARACA.get()));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)InstrumentalRegistry.MARACA.get()));
        this.setDropChance(EquipmentSlot.MAINHAND, this.getDropChance());
        this.setDropChance(EquipmentSlot.OFFHAND, this.getDropChance());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        RandomSource randomSource = serverLevelAccessor.getRandom();
        spawnGroupData = super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
        this.populateDefaultEquipmentSlots(randomSource, difficultyInstance);
        return spawnGroupData;
    }

    static class SpiderInstrumentAttack
    extends InstrumentAttackGoal {
        public SpiderInstrumentAttack(MaracaSpider spider) {
            super((PathfinderMob)spider, 1.0, true, InstrumentalSounds.MARACA_SOUND::get);
        }

        public boolean canContinueToUse() {
            float f = this.mob.getLightLevelDependentMagicValue();
            if (f >= 0.5f && this.mob.getRandom().nextInt(100) == 0) {
                this.mob.setTarget((LivingEntity)null);
                return false;
            }
            return super.canContinueToUse();
        }

        public void stop() {
            super.stop();
            MaracaSpider spider = (MaracaSpider)this.mob;
            spider.setAttacking(false);
            spider.swinging = false;
        }

        public void start() {
            super.start();
            MaracaSpider spider = (MaracaSpider)this.mob;
            spider.setAttacking(true);
            spider.swing(InteractionHand.MAIN_HAND);
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return 4.0f + attackTarget.getBbWidth();
        }
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(MaracaSpider spider, Class<T> classTarget) {
            super((Mob)spider, classTarget, true);
        }

        public boolean canUse() {
            float f = this.mob.getLightLevelDependentMagicValue();
            return !(f >= 0.5f) && super.canUse();
        }
    }
}

