/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.datagen;

import com.mrbysco.instrumentalmobs.datagen.InstrumentalDamageTypeProvider;
import com.mrbysco.instrumentalmobs.datagen.assets.InstrumentalLanguageProvider;
import com.mrbysco.instrumentalmobs.datagen.assets.InstrumentalSoundProvider;
import com.mrbysco.instrumentalmobs.datagen.data.InstrumentalAdvancementProvider;
import com.mrbysco.instrumentalmobs.datagen.data.InstrumentalLoot;
import com.mrbysco.instrumentalmobs.datagen.data.InstrumentalRecipeProvider;
import com.mrbysco.instrumentalmobs.modifier.AddRelativeSpawnBiomeModifier;
import com.mrbysco.instrumentalmobs.registration.InstrumentalEntities;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class InstrumentalDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(InstrumentalDataGen::getProvider), Set.of("instrumentalmobs")));
            generator.addProvider(event.includeServer(), (DataProvider)new InstrumentalAdvancementProvider(packOutput, lookupProvider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new InstrumentalLoot(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new InstrumentalRecipeProvider(packOutput, lookupProvider));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new InstrumentalLanguageProvider(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new InstrumentalSoundProvider(packOutput, helper));
        }
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.DAMAGE_TYPE, InstrumentalDamageTypeProvider::bootstrap);
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
            InstrumentalDataGen.registerModifier((BootstrapContext<BiomeModifier>)context, EntityType.HUSK, InstrumentalEntities.CYMBAL_HUSK.get(), 5);
            InstrumentalDataGen.registerModifier((BootstrapContext<BiomeModifier>)context, EntityType.ZOMBIE, InstrumentalEntities.DRUM_ZOMBIE.get(), 5);
            InstrumentalDataGen.registerModifier((BootstrapContext<BiomeModifier>)context, EntityType.CREEPER, InstrumentalEntities.FRENCH_HORN_CREEPER.get(), 5);
            InstrumentalDataGen.registerModifier((BootstrapContext<BiomeModifier>)context, EntityType.SPIDER, InstrumentalEntities.MARACA_SPIDER.get(), 5);
            InstrumentalDataGen.registerModifier((BootstrapContext<BiomeModifier>)context, EntityType.GHAST, InstrumentalEntities.MICROPHONE_GHAST.get(), 5);
            InstrumentalDataGen.registerModifier((BootstrapContext<BiomeModifier>)context, EntityType.ENDERMAN, InstrumentalEntities.TUBA_ENDERMAN.get(), 5);
            InstrumentalDataGen.registerModifier((BootstrapContext<BiomeModifier>)context, EntityType.SKELETON, InstrumentalEntities.XYLOPHONE_SKELETON.get(), 5);
            InstrumentalDataGen.registerModifier((BootstrapContext<BiomeModifier>)context, EntityType.SKELETON, InstrumentalEntities.TRUMPET_SKELETON.get(), 5);
        });
        registryBuilder.add(Registries.BIOME, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }

    private static void registerModifier(BootstrapContext<BiomeModifier> context, EntityType<?> originalType, EntityType<?> newType, int relativeWeight) {
        context.register(InstrumentalDataGen.getModifierKey(newType), (Object)new AddRelativeSpawnBiomeModifier(originalType, newType, relativeWeight));
    }

    private static ResourceKey<BiomeModifier> getModifierKey(EntityType<?> type) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BuiltInRegistries.ENTITY_TYPE.getKey(type));
    }
}

