/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.config;

import com.mrbysco.instrumentalmobs.Constants;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class InstrumentalConfigForge {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Constants.LOGGER.debug("Loaded Instrumental Mobs' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Constants.LOGGER.debug("Instrumental Mobs' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue mobsReact;
        public final ModConfigSpec.DoubleValue instrumentRange;
        public final ModConfigSpec.DoubleValue soundDamageChance;
        public final ModConfigSpec.DoubleValue instrumentDropChance;
        public final ModConfigSpec.DoubleValue instrumentHurtChance;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Server settings").push("Server");
            this.mobsReact = builder.comment("Mobs react upon usage of the instruments [default: true]").define("mobsReact", true);
            this.instrumentRange = builder.comment("The area in which the instruments react with mobs. [default: 10.0]").defineInRange("instrumentRange", 10.0, 0.01, 128.0);
            this.soundDamageChance = builder.comment("The chance of instrument sounds damaging mobs after pushing. [default: 0.35]").defineInRange("soundDamageChance", 0.35, 0.001, 1.0);
            this.instrumentDropChance = builder.comment("The chance of instrument dropping from a mob holding one [default: 0.5]").defineInRange("instrumentDropChance", 0.5, 0.0, 1.0);
            this.instrumentHurtChance = builder.comment("The chance of instrument hurting nearby entities upon sounding [default: 0.3]").defineInRange("instrumentHurtChance", 0.3, 0.0, 1.0);
            builder.pop();
        }
    }
}

