/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.instrumentalmobs.entities.XylophoneSkeleton;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class XylophoneSkeletonModel<T extends XylophoneSkeleton>
extends SkeletonModel<T> {
    public XylophoneSkeletonModel(ModelPart part) {
        super(part);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ItemStack stack = entityIn.getMainHandItem();
        if (((XylophoneSkeleton)entityIn).isPlayingInstrument() && stack.getItem() == Items.BONE) {
            float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
            float f1 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
            this.rightArm.zRot = 0.0f;
            this.leftArm.zRot = 0.0f;
            this.rightArm.yRot = -(0.1f - f * 0.6f);
            this.leftArm.yRot = 0.1f - f * 0.6f;
            float f3 = Mth.cos((float)(ageInTicks * 0.09f)) * -7.853982f;
            this.rightArm.zRot = -f3;
            this.leftArm.zRot = f3;
            this.leftArm.xRot = 1.0f;
            this.rightArm.xRot = -1.0f;
            this.rightArm.xRot = -1.5707964f;
            this.leftArm.xRot = -1.5707964f;
            this.rightArm.xRot -= f * 1.2f - f1 * 0.4f;
            this.leftArm.xRot -= f * 1.2f - f1 * 0.4f;
            this.rightArm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.leftArm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.rightArm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftArm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        }
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelPart = this.getArm(arm);
        modelPart.x += f;
        modelPart.translateAndRotate(poseStack);
        modelPart.x -= f;
    }
}

