/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.instrumentalmobs.entities.MaracaSpider;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.HumanoidArm;
import org.joml.Vector3f;

public class MaracaSpiderModel<T extends MaracaSpider>
extends SpiderModel<T>
implements ArmedModel {
    public MaracaSpiderModel(ModelPart part) {
        super(part);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (((MaracaSpider)entityIn).isAttacking() && entityIn.getRandom().nextFloat() > 0.5f) {
            float randAngle = entityIn.getRandom().nextInt(45);
            this.rightFrontLeg.yRot += randAngle;
            this.leftFrontLeg.yRot += randAngle;
        }
    }

    protected ModelPart getLegForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.rightFrontLeg : this.leftFrontLeg;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        this.getLegForSide(arm).translateAndRotate(poseStack);
        poseStack.mulPose(Axis.XP.rotation(-90.0f));
        poseStack.mulPose(Axis.YP.rotation(180.0f));
        poseStack.mulPose(Axis.XP.rotation(90.0f));
        boolean flag = arm == HumanoidArm.LEFT;
        poseStack.mulPose(Axis.of((Vector3f)new Vector3f(0.0f, flag ? -0.23f : 0.23f, flag ? -0.23f : 0.23f)).rotationDegrees(90.0f));
        poseStack.translate(flag ? 0.315f : -0.6125f, flag ? -0.125f : -1.3125f, flag ? -0.6875f : 0.425f);
    }
}

