/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class TubaEndermanHeldItemLayer<T extends EnderMan, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ItemInHandRenderer itemInHandRenderer;

    public TubaEndermanHeldItemLayer(RenderLayerParent<T, M> layerParent, ItemInHandRenderer itemInHandRenderer) {
        super(layerParent);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, T enderman, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = enderman.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            ((HeadedModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
            poseStack.translate(0.0f, -0.73f, -0.775f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-10.0f));
            poseStack.translate(-0.8f, 0.0f, 0.0f);
            this.itemInHandRenderer.renderItem(enderman, stack, ItemDisplayContext.NONE, false, poseStack, bufferSource, packedLightIn);
            poseStack.popPose();
        }
    }
}

