/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.instrumentalmobs.entities.MicrophoneGhast;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class MicrophoneLayer<T extends Ghast, M extends GhastModel<T>>
extends RenderLayer<T, M> {
    private final ItemInHandRenderer itemInHandRenderer;

    public MicrophoneLayer(RenderLayerParent<T, M> layerParent, ItemInHandRenderer itemInHandRenderer) {
        super(layerParent);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, T ghast, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        MicrophoneGhast microphoneGhast;
        ItemStack stack = ghast.getItemBySlot(EquipmentSlot.HEAD);
        if (!stack.isEmpty() && ghast instanceof MicrophoneGhast && !(microphoneGhast = (MicrophoneGhast)ghast).isSinging()) {
            poseStack.pushPose();
            poseStack.scale(0.25f, 0.25f, 0.25f);
            poseStack.mulPose(Axis.XP.rotationDegrees(-180.0f));
            poseStack.translate(-0.5f, -6.0f, 2.0f);
            this.itemInHandRenderer.renderItem(ghast, stack, ItemDisplayContext.NONE, false, poseStack, bufferSource, packedLightIn);
            poseStack.popPose();
        }
    }
}

