/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.instrumentalmobs.entities.XylophoneSkeleton;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class HeldBoneLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ItemInHandRenderer itemInHandRenderer;

    public HeldBoneLayer(RenderLayerParent<T, M> layerParent, ItemInHandRenderer itemInHandRenderer) {
        super(layerParent);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack1;
        boolean flag = livingEntity.getMainArm() == HumanoidArm.RIGHT;
        ItemStack itemstack = flag ? livingEntity.getOffhandItem() : livingEntity.getMainHandItem();
        ItemStack itemStack = itemstack1 = flag ? livingEntity.getMainHandItem() : livingEntity.getOffhandItem();
        if (!itemstack.isEmpty() || !itemstack1.isEmpty()) {
            poseStack.pushPose();
            if (livingEntity.isBaby()) {
                float f = 0.5f;
                poseStack.translate(0.0f, 0.75f, 0.0f);
                poseStack.scale(f, f, f);
            }
            this.renderHeldItem((LivingEntity)livingEntity, itemstack1, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, bufferIn, packedLightIn);
            this.renderHeldItem((LivingEntity)livingEntity, itemstack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, bufferIn, packedLightIn);
            poseStack.popPose();
        }
    }

    private void renderHeldItem(LivingEntity livingBase, ItemStack stack, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        if (!stack.isEmpty()) {
            XylophoneSkeleton skeletal;
            boolean flag2;
            boolean flag;
            poseStack.pushPose();
            if (livingBase.isShiftKeyDown()) {
                poseStack.translate(0.0f, 0.2f, 0.0f);
            }
            ((ArmedModel)this.getParentModel()).translateToHand(arm, poseStack);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            boolean bl = flag = arm == HumanoidArm.LEFT;
            if (livingBase instanceof XylophoneSkeleton && (flag2 = (skeletal = (XylophoneSkeleton)livingBase).isPlayingInstrument())) {
                poseStack.scale(0.75f, 0.75f, 0.75f);
                poseStack.translate(0.0f, -0.225f, -0.5f);
                poseStack.mulPose(Axis.of((Vector3f)new Vector3f(1.0f, flag ? -0.2f : 0.2f, flag ? -0.2f : 0.2f)).rotationDegrees(45.0f));
            }
            poseStack.translate((double)((float)(flag ? -1 : 1) / 16.0f), 0.125, -0.625);
            this.itemInHandRenderer.renderItem(livingBase, stack, displayContext, flag, poseStack, bufferSource, packedLightIn);
            poseStack.popPose();
        }
    }
}

