/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.instrumentalmobs.entities.FrenchHornCreeper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class FrenchHornLayer<T extends FrenchHornCreeper, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ItemInHandRenderer itemInHandRenderer;

    public FrenchHornLayer(RenderLayerParent<T, M> layerParent, ItemInHandRenderer itemInHandRenderer) {
        super(layerParent);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, T frenchHornCreeper, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = frenchHornCreeper.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!itemstack.isEmpty()) {
            poseStack.pushPose();
            ((HeadedModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
            poseStack.scale(0.75f, 0.75f, 0.75f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.translate(0.85f, 0.15f, 0.0f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(-20.0f));
            this.itemInHandRenderer.renderItem(frenchHornCreeper, itemstack, ItemDisplayContext.NONE, false, poseStack, bufferSource, packedLightIn);
            poseStack.popPose();
        }
    }
}

