/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.instrumentalmobs.client.render.layers.TubaEndermanEyesLayer;
import com.mrbysco.instrumentalmobs.client.render.layers.TubaEndermanHeldItemLayer;
import com.mrbysco.instrumentalmobs.client.render.model.TubaEndermanModel;
import com.mrbysco.instrumentalmobs.entities.TubaEnderman;
import java.util.Random;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TubaEndermanRenderer
extends MobRenderer<TubaEnderman, TubaEndermanModel<TubaEnderman>> {
    private static final ResourceLocation ENDERMAN_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/entity/enderman/enderman.png");
    private final Random rnd = new Random();

    public TubaEndermanRenderer(EntityRendererProvider.Context context) {
        super(context, new TubaEndermanModel(context.bakeLayer(ModelLayers.ENDERMAN)), 0.5f);
        this.addLayer((RenderLayer)new TubaEndermanEyesLayer(this));
        this.addLayer(new TubaEndermanHeldItemLayer(this, context.getItemInHandRenderer()));
    }

    public void render(TubaEnderman tubaEnderman, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        BlockState blockstate = tubaEnderman.getCarriedBlock();
        EndermanModel endermanmodel = (EndermanModel)this.getModel();
        endermanmodel.carrying = blockstate != null;
        endermanmodel.creepy = tubaEnderman.isCreepy();
        super.render((LivingEntity)tubaEnderman, entityYaw, partialTicks, poseStack, bufferSource, packedLightIn);
    }

    public Vec3 getRenderOffset(TubaEnderman tubaEnderman, float partialTicks) {
        if (tubaEnderman.isCreepy()) {
            double d0 = 0.02;
            return new Vec3(this.rnd.nextGaussian() * 0.02, 0.0, this.rnd.nextGaussian() * 0.02);
        }
        return super.getRenderOffset((Entity)tubaEnderman, partialTicks);
    }

    public ResourceLocation getTextureLocation(TubaEnderman tubaEnderman) {
        return ENDERMAN_TEXTURES;
    }
}

