/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.instrumentalmobs.client.render.layers.FrenchHornCreeperCharge;
import com.mrbysco.instrumentalmobs.client.render.layers.FrenchHornLayer;
import com.mrbysco.instrumentalmobs.client.render.model.FrenchHornCreeperModel;
import com.mrbysco.instrumentalmobs.entities.FrenchHornCreeper;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class FrenchHornCreeperRenderer
extends MobRenderer<FrenchHornCreeper, FrenchHornCreeperModel<FrenchHornCreeper>> {
    private static final ResourceLocation CREEPER_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/entity/creeper/creeper.png");

    public FrenchHornCreeperRenderer(EntityRendererProvider.Context context) {
        super(context, new FrenchHornCreeperModel(context.bakeLayer(ModelLayers.CREEPER)), 0.5f);
        this.addLayer((RenderLayer)new FrenchHornCreeperCharge((RenderLayerParent<FrenchHornCreeper, FrenchHornCreeperModel<FrenchHornCreeper>>)this, context.getModelSet()));
        this.addLayer(new FrenchHornLayer(this, context.getItemInHandRenderer()));
    }

    protected void scale(FrenchHornCreeper frenchHornCreeper, PoseStack poseStack, float partialTickTime) {
        float f = frenchHornCreeper.getSwelling(partialTickTime);
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        poseStack.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(FrenchHornCreeper frenchHornCreeper, float partialTicks) {
        float f = frenchHornCreeper.getSwelling(partialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(FrenchHornCreeper frenchHornCreeper) {
        return CREEPER_TEXTURES;
    }
}

