/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.library.helpers;

import cjminecraft.doubleslabs.api.helpers.IHorizontalSlabHelper;
import cjminecraft.doubleslabs.api.helpers.ISlabAbilities;
import cjminecraft.doubleslabs.api.helpers.ISlabHelper;
import cjminecraft.doubleslabs.api.helpers.IVerticalSlabHelper;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SlabHelper
implements ISlabHelper {
    private final List<IHorizontalSlabHelper> horizontalSlabHelpers = new ArrayList<IHorizontalSlabHelper>();
    private final List<IVerticalSlabHelper> verticalSlabHelpers = new ArrayList<IVerticalSlabHelper>();
    private final Map<Block, ISlabAbilities> slabAbilities = new IdentityHashMap<Block, ISlabAbilities>();

    public void addHorizontalSlabSupport(IHorizontalSlabHelper helper) {
        this.horizontalSlabHelpers.add(helper);
    }

    public void addVerticalSlabSupport(IVerticalSlabHelper helper) {
        this.verticalSlabHelpers.add(helper);
    }

    public void registerSlabAbilities(ISlabAbilities abilities, Block ... blocks) {
        for (Block block : blocks) {
            this.slabAbilities.put(block, abilities);
        }
    }

    @Override
    public Optional<IHorizontalSlabHelper> getHorizontalSlabHelper(BlockState state) {
        IHorizontalSlabHelper helper2;
        Block block = state.getBlock();
        if (block instanceof IHorizontalSlabHelper && (helper2 = (IHorizontalSlabHelper)block).isHorizontalSlab(state)) {
            return Optional.of(helper2);
        }
        return this.horizontalSlabHelpers.stream().filter(helper -> helper.isHorizontalSlab(state)).findFirst();
    }

    @Override
    public Optional<IVerticalSlabHelper> getVerticalSlabHelper(BlockState state) {
        IVerticalSlabHelper helper2;
        Block block = state.getBlock();
        if (block instanceof IVerticalSlabHelper && (helper2 = (IVerticalSlabHelper)block).isVerticalSlab(state)) {
            return Optional.of(helper2);
        }
        return this.verticalSlabHelpers.stream().filter(helper -> helper.isVerticalSlab(state)).findFirst();
    }

    @Override
    public Optional<IHorizontalSlabHelper> getHorizontalSlabHelper(ItemStack stack) {
        IHorizontalSlabHelper support;
        BlockItem blockItem;
        IHorizontalSlabHelper helper2;
        Item item = stack.getItem();
        if (item instanceof IHorizontalSlabHelper && (helper2 = (IHorizontalSlabHelper)item).isHorizontalSlab(stack)) {
            return Optional.of(helper2);
        }
        Item item2 = stack.getItem();
        if (item2 instanceof BlockItem && (item2 = (blockItem = (BlockItem)item2).getBlock()) instanceof IHorizontalSlabHelper && (support = (IHorizontalSlabHelper)item2).isHorizontalSlab(stack)) {
            return Optional.of(support);
        }
        return this.horizontalSlabHelpers.stream().filter(helper -> helper.isHorizontalSlab(stack)).findFirst();
    }

    @Override
    public Optional<IVerticalSlabHelper> getVerticalSlabHelper(ItemStack stack) {
        IVerticalSlabHelper support;
        BlockItem blockItem;
        IVerticalSlabHelper helper2;
        Item item = stack.getItem();
        if (item instanceof IVerticalSlabHelper && (helper2 = (IVerticalSlabHelper)item).isVerticalSlab(stack)) {
            return Optional.of(helper2);
        }
        Item item2 = stack.getItem();
        if (item2 instanceof BlockItem && (item2 = (blockItem = (BlockItem)item2).getBlock()) instanceof IVerticalSlabHelper && (support = (IVerticalSlabHelper)item2).isVerticalSlab(stack)) {
            return Optional.of(support);
        }
        return this.verticalSlabHelpers.stream().filter(helper -> helper.isVerticalSlab(stack)).findFirst();
    }

    @Override
    public Optional<IHorizontalSlabHelper> getHorizontalSlabHelper(Block block) {
        IHorizontalSlabHelper helper2;
        if (block instanceof IHorizontalSlabHelper && (helper2 = (IHorizontalSlabHelper)block).isHorizontalSlab(block)) {
            return Optional.of(helper2);
        }
        return this.horizontalSlabHelpers.stream().filter(helper -> helper.isHorizontalSlab(block)).findFirst();
    }

    @Override
    public Optional<IVerticalSlabHelper> getVerticalSlabHelper(Block block) {
        IVerticalSlabHelper helper2;
        if (block instanceof IVerticalSlabHelper && (helper2 = (IVerticalSlabHelper)block).isVerticalSlab(block)) {
            return Optional.of(helper2);
        }
        return this.verticalSlabHelpers.stream().filter(helper -> helper.isVerticalSlab(block)).findFirst();
    }

    @Override
    public Optional<IHorizontalSlabHelper> getHorizontalSlabHelper(Item item) {
        IHorizontalSlabHelper support;
        BlockItem blockItem;
        Block block;
        IHorizontalSlabHelper helper2;
        if (item instanceof IHorizontalSlabHelper && (helper2 = (IHorizontalSlabHelper)item).isHorizontalSlab(item)) {
            return Optional.of(helper2);
        }
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof IHorizontalSlabHelper && (support = (IHorizontalSlabHelper)block).isHorizontalSlab(item)) {
            return Optional.of(support);
        }
        return this.horizontalSlabHelpers.stream().filter(helper -> helper.isHorizontalSlab(item)).findFirst();
    }

    @Override
    public Optional<IVerticalSlabHelper> getVerticalSlabHelper(Item item) {
        IVerticalSlabHelper support;
        BlockItem blockItem;
        Block block;
        IVerticalSlabHelper helper2;
        if (item instanceof IVerticalSlabHelper && (helper2 = (IVerticalSlabHelper)item).isVerticalSlab(item)) {
            return Optional.of(helper2);
        }
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof IVerticalSlabHelper && (support = (IVerticalSlabHelper)block).isVerticalSlab(item)) {
            return Optional.of(support);
        }
        return this.verticalSlabHelpers.stream().filter(helper -> helper.isVerticalSlab(item)).findFirst();
    }

    @Override
    public boolean areSameTypeOfSlab(BlockState state, IHorizontalSlabHelper stateSlabHelper, ItemStack stack, IHorizontalSlabHelper stackSlabHelper) {
        return stateSlabHelper == stackSlabHelper && stackSlabHelper.areSameTypeOfSlab(state, stack);
    }

    @Override
    public boolean areSameTypeOfSlab(BlockState state, IVerticalSlabHelper stateSlabHelper, ItemStack stack, IVerticalSlabHelper stackSlabHelper) {
        return stateSlabHelper == stackSlabHelper && stackSlabHelper.areSameTypeOfSlab(state, stack);
    }

    @Override
    public Optional<ISlabAbilities> getSlabAbilities(Block block) {
        if (block instanceof ISlabAbilities) {
            ISlabAbilities abilities = (ISlabAbilities)block;
            return Optional.of(abilities);
        }
        return this.slabAbilities.containsKey(block) ? Optional.of(this.slabAbilities.get(block)) : Optional.empty();
    }
}

