/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.hooks;

import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.api.state.IDynamicSlabStateContainer;
import cjminecraft.doubleslabs.api.state.ISlabStateContainer;
import cjminecraft.doubleslabs.common.Internal;
import cjminecraft.doubleslabs.common.init.DSBlockEntities;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class DynamicSlabBlockHooks {
    protected static Optional<? extends IDynamicSlabStateContainer> getDynamicSlabStateContainer(BlockGetter blockGetter, BlockPos pos) {
        return blockGetter.getBlockEntity(pos, DSBlockEntities.DYNAMIC_SLAB.get());
    }

    protected static Optional<Float> minFromBlockState(BlockGetter blockGetter, BlockPos pos, Function<BlockState, Float> function) {
        return DynamicSlabBlockHooks.getDynamicSlabStateContainer(blockGetter, pos).flatMap(container -> container.reduceOnBlockStates(function, Math::min));
    }

    protected static void runOnBlockState(BlockGetter blockGetter, BlockPos pos, Half slabHalf, Consumer<BlockState> consumer) {
        DynamicSlabBlockHooks.getDynamicSlabStateContainer(blockGetter, pos).ifPresent(container -> container.runOnBlockState(slabHalf, consumer));
    }

    protected static <T> Optional<T> callOnBlockState(BlockGetter blockGetter, BlockPos pos, Half slabHalf, Function<BlockState, T> function) {
        return DynamicSlabBlockHooks.getDynamicSlabStateContainer(blockGetter, pos).flatMap(container -> container.callOnBlockState(slabHalf, function));
    }

    protected static <T> Optional<T> reduceOnBlockStates(BlockGetter blockGetter, BlockPos pos, Function<BlockState, T> function, BiFunction<T, T, T> reducer) {
        return DynamicSlabBlockHooks.getDynamicSlabStateContainer(blockGetter, pos).flatMap(container -> container.reduceOnBlockStates(function, reducer));
    }

    protected static boolean requireBothStates(BlockGetter blockGetter, BlockPos pos, Function<BlockState, Boolean> function) {
        return DynamicSlabBlockHooks.getDynamicSlabStateContainer(blockGetter, pos).flatMap(container -> container.reduceOnBlockStates(function, Boolean::logicalAnd)).orElse(false);
    }

    protected static boolean requireEitherStates(BlockGetter blockGetter, BlockPos pos, Function<BlockState, Boolean> function) {
        return DynamicSlabBlockHooks.getDynamicSlabStateContainer(blockGetter, pos).flatMap(container -> container.reduceOnBlockStates(function, Boolean::logicalOr)).orElse(true);
    }

    protected static void destroyHalf(IDynamicSlabStateContainer container, Player player, Level level, BlockPos pos, ItemStack tool, Half halfToRemove, Consumer<ISlabStateContainer> dropResources) {
        container.runOnStateContainer(halfToRemove, slabContainer -> {
            if (!slabContainer.hasBlockState()) {
                return;
            }
            BlockState slabState = slabContainer.getBlockState();
            player.awardStat(Stats.BLOCK_MINED.get((Object)slabState.getBlock()));
            level.levelEvent(2001, pos, Block.getId((BlockState)slabState));
            player.causeFoodExhaustion(0.005f);
            if (!player.isCreative()) {
                dropResources.accept((ISlabStateContainer)slabContainer);
            }
            slabState.onRemove(level, pos, Blocks.AIR.defaultBlockState(), false);
        });
    }

    public static void randomTick(ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        DynamicSlabBlockHooks.getDynamicSlabStateContainer((BlockGetter)serverLevel, pos).ifPresent(container -> container.runOnStateContainers(stateContainer -> {
            BlockState state = stateContainer.getBlockState();
            Internal.getSlabHelper().getSlabAbilities(state.getBlock()).ifPresent(abilities -> {
                if (abilities.isRandomlyTicking(state)) {
                    abilities.randomTick((ISlabStateContainer)stateContainer, serverLevel, pos, random);
                }
            });
        }));
    }

    public static void neighborChanged(Level level, BlockPos pos, Block neighborBlock, boolean movedByPiston) {
        DynamicSlabBlockHooks.getDynamicSlabStateContainer((BlockGetter)level, pos).ifPresent(container -> container.runOnStateContainers(stateContainer -> {
            BlockState state = stateContainer.getBlockState();
            Internal.getSlabHelper().getSlabAbilities(state.getBlock()).ifPresent(abilities -> abilities.neighborChanged((ISlabStateContainer)stateContainer, level, pos, neighborBlock, movedByPiston));
        }));
    }

    public static void tick(ServerLevel level, BlockPos pos, RandomSource random) {
        DynamicSlabBlockHooks.getDynamicSlabStateContainer((BlockGetter)level, pos).ifPresent(container -> container.runOnStateContainers(stateContainer -> {
            BlockState state = stateContainer.getBlockState();
            Internal.getSlabHelper().getSlabAbilities(state.getBlock()).ifPresent(abilities -> abilities.tick((ISlabStateContainer)stateContainer, level, pos, random));
        }));
    }

    public static void entityInside(Level level, BlockPos pos, Entity entity) {
        DynamicSlabBlockHooks.getDynamicSlabStateContainer((BlockGetter)level, pos).ifPresent(container -> container.runOnBlockStates(state -> state.entityInside(level, pos, entity)));
    }
}

