/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.helpers.IHorizontalSlabHelper;
import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.client.model.PlatformIndependentModelBaker;
import cjminecraft.doubleslabs.common.Constants;
import cjminecraft.doubleslabs.common.Internal;
import cjminecraft.doubleslabs.library.helpers.VerticalSlabModelHelper;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class VerticalSlabModelBaker {
    private final Map<BlockState, Map<Direction, BakedModel>> verticalModels = new HashMap<BlockState, Map<Direction, BakedModel>>();
    private final Map<Item, BakedModel> itemModels = new HashMap<Item, BakedModel>();
    protected final PlatformIndependentModelBaker modelBaker;

    public VerticalSlabModelBaker(PlatformIndependentModelBaker modelBaker) {
        this.modelBaker = modelBaker;
    }

    public VerticalSlabModelHelper createModelHelper() {
        return new VerticalSlabModelHelper(this.verticalModels, this.itemModels);
    }

    public void bakeBlocks(Iterable<Block> blocks) {
        this.verticalModels.clear();
        int count = 0;
        for (Block block : blocks) {
            Optional<IHorizontalSlabHelper> helper = Internal.getSlabHelper().getHorizontalSlabHelper(block);
            if (!helper.isPresent()) continue;
            this.bakeVariants(block, helper.get());
            ++count;
        }
        Constants.LOG.info("Baked vertical slab models for {} slabs", (Object)count);
    }

    public void bakeItems(Iterable<Item> items, Function<Item, ResourceLocation> lookupResourceLocation) {
        this.itemModels.clear();
        int count = 0;
        for (Item item : items) {
            Optional<IHorizontalSlabHelper> helper = Internal.getSlabHelper().getHorizontalSlabHelper(item);
            if (!helper.isPresent()) continue;
            this.bake(item, lookupResourceLocation.apply(item));
            ++count;
        }
        Constants.LOG.info("Baked vertical slab item models for {} slabs", (Object)count);
    }

    private void bake(Item item, ResourceLocation registryName) {
        UnbakedModel model = this.modelBaker.getModel(registryName.withPrefix("item/"));
        if (!(model instanceof BlockModel)) {
            Constants.LOG.warn("Cannot bake vertical slab model for {} as it does not use a block model", (Object)registryName);
            return;
        }
        BlockModel blockModel = (BlockModel)model;
        BakedModel bakedModel = blockModel.bake((ModelBaker)this.modelBaker, blockModel, this.modelBaker::getTextureSprite, (ModelState)BlockModelRotation.X90_Y0, false);
        this.itemModels.put(item, bakedModel);
    }

    private void bakeVariants(Block block, IHorizontalSlabHelper helper) {
        block.getStateDefinition().getPossibleStates().stream().filter(Predicates.not(helper::isDoubleSlab).and(state -> !state.hasProperty((Property)BlockStateProperties.WATERLOGGED) || (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false)).forEach(state -> this.bake((BlockState)state, helper));
    }

    private void bake(BlockState state, IHorizontalSlabHelper helper) {
        ModelResourceLocation resourceLocation = BlockModelShaper.stateToModelLocation((BlockState)state);
        Half half = helper.getHalf(state);
        EnumMap directionalModels = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            directionalModels.put(direction, this.modelBaker.bake(resourceLocation, VerticalSlabModelBaker.getVerticalModelRotation(half, direction)));
        }
        this.verticalModels.put(state, directionalModels);
    }

    private static ModelState getVerticalModelRotation(Half half, Direction direction) {
        return switch (half == Half.NEGATIVE ? direction : direction.getOpposite()) {
            case Direction.NORTH -> BlockModelRotation.X90_Y180;
            case Direction.EAST -> BlockModelRotation.X90_Y270;
            case Direction.SOUTH -> BlockModelRotation.X90_Y0;
            case Direction.WEST -> BlockModelRotation.X90_Y90;
            default -> BlockModelRotation.X0_Y0;
        };
    }
}

