/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformIndependentModelBaker
implements ModelBaker {
    protected final ModelBakery bakery;
    protected final ModelManager manager;

    public PlatformIndependentModelBaker(ModelBakery bakery, ModelManager manager) {
        this.bakery = bakery;
        this.manager = manager;
    }

    public UnbakedModel getModel(ResourceLocation resourceLocation) {
        return this.bakery.getModel(resourceLocation);
    }

    @Nullable
    public UnbakedModel getTopLevelModel(ModelResourceLocation modelResourceLocation) {
        return (UnbakedModel)this.bakery.topLevelModels.get(modelResourceLocation);
    }

    @Nullable
    public BakedModel bake(ResourceLocation resourceLocation, ModelState modelState) {
        return this.bake(this.getModel(resourceLocation), modelState);
    }

    @Nullable
    public BakedModel bake(ModelResourceLocation modelResourceLocation, ModelState modelState) {
        return this.bake(this.getTopLevelModel(modelResourceLocation), modelState);
    }

    @Nullable
    private BakedModel bake(@Nullable UnbakedModel model, ModelState modelState) {
        if (model == null) {
            return null;
        }
        if (model instanceof MultiVariant) {
            MultiVariant multiVariant = (MultiVariant)model;
            if (multiVariant.getVariants().isEmpty()) {
                return null;
            }
            WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
            for (Variant variant : multiVariant.getVariants()) {
                BakedModel bakedVariant = this.bake(variant.getModelLocation(), (ModelState)new Variant(variant.getModelLocation(), modelState.getRotation().compose(variant.getRotation()), modelState.isUvLocked() || variant.isUvLocked(), variant.getWeight()));
                builder.add(bakedVariant, variant.getWeight());
            }
            return builder.build();
        }
        return model.bake((ModelBaker)this, this::getTextureSprite, modelState);
    }

    public TextureAtlasSprite getTextureSprite(Material material) {
        return this.manager.getAtlas(material.atlasLocation()).getSprite(material.texture());
    }
}

