/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.colored.util;

import com.benbenlaw.core.config.ColorTintIndexConfig;
import java.util.HashMap;
import net.minecraft.world.item.DyeColor;

public class ColorMap {
    public static final HashMap<DyeColor, Integer> COLOR_MAP = new HashMap<DyeColor, Integer>(){
        {
            this.put(DyeColor.WHITE, (Integer)ColorTintIndexConfig.whiteTintIndex.get());
            this.put(DyeColor.ORANGE, (Integer)ColorTintIndexConfig.orangeTintIndex.get());
            this.put(DyeColor.LIGHT_BLUE, (Integer)ColorTintIndexConfig.lightBlueTintIndex.get());
            this.put(DyeColor.CYAN, (Integer)ColorTintIndexConfig.cyanTintIndex.get());
            this.put(DyeColor.PINK, (Integer)ColorTintIndexConfig.pinkTintIndex.get());
            this.put(DyeColor.YELLOW, (Integer)ColorTintIndexConfig.yellowTintIndex.get());
            this.put(DyeColor.LIGHT_GRAY, (Integer)ColorTintIndexConfig.lightGrayTintIndex.get());
            this.put(DyeColor.GRAY, (Integer)ColorTintIndexConfig.grayTintIndex.get());
            this.put(DyeColor.RED, (Integer)ColorTintIndexConfig.redTintIndex.get());
            this.put(DyeColor.LIME, (Integer)ColorTintIndexConfig.limeTintIndex.get());
            this.put(DyeColor.BLUE, (Integer)ColorTintIndexConfig.blueTintIndex.get());
            this.put(DyeColor.PURPLE, (Integer)ColorTintIndexConfig.purpleTintIndex.get());
            this.put(DyeColor.BROWN, (Integer)ColorTintIndexConfig.brownTintIndex.get());
            this.put(DyeColor.GREEN, (Integer)ColorTintIndexConfig.greenTintIndex.get());
            this.put(DyeColor.BLACK, (Integer)ColorTintIndexConfig.blackTintIndex.get());
            this.put(DyeColor.MAGENTA, (Integer)ColorTintIndexConfig.magentaTintIndex.get());
        }
    };
    private static final HashMap<String, DyeColor> STRING_TO_DYE_COLOR = new HashMap<String, DyeColor>(){
        {
            this.put("white", DyeColor.WHITE);
            this.put("orange", DyeColor.ORANGE);
            this.put("light_blue", DyeColor.LIGHT_BLUE);
            this.put("cyan", DyeColor.CYAN);
            this.put("pink", DyeColor.PINK);
            this.put("yellow", DyeColor.YELLOW);
            this.put("light_gray", DyeColor.LIGHT_GRAY);
            this.put("gray", DyeColor.GRAY);
            this.put("red", DyeColor.RED);
            this.put("lime", DyeColor.LIME);
            this.put("blue", DyeColor.BLUE);
            this.put("purple", DyeColor.PURPLE);
            this.put("brown", DyeColor.BROWN);
            this.put("green", DyeColor.GREEN);
            this.put("black", DyeColor.BLACK);
            this.put("magenta", DyeColor.MAGENTA);
        }
    };
    private static final HashMap<String, String> STRING_TO_STRING_TRANSLATION = new HashMap<String, String>(){
        {
            this.put("white", "color.bblcore.white");
            this.put("orange", "color.bblcore.orange");
            this.put("light_blue", "color.bblcore.light_blue");
            this.put("cyan", "color.bblcore.cyan");
            this.put("pink", "color.bblcore.pink");
            this.put("yellow", "color.bblcore.yellow");
            this.put("light_gray", "color.bblcore.light_gray");
            this.put("gray", "color.bblcore.gray");
            this.put("red", "color.bblcore.red");
            this.put("lime", "color.bblcore.lime");
            this.put("blue", "color.bblcore.blue");
            this.put("purple", "color.bblcore.purple");
            this.put("brown", "color.bblcore.brown");
            this.put("green", "color.bblcore.green");
            this.put("black", "color.bblcore.black");
            this.put("magenta", "color.bblcore.magenta");
        }
    };

    public static Integer getColorValue(DyeColor dyeColor) {
        return COLOR_MAP.get(dyeColor);
    }

    public static DyeColor getDyeColor(String colorName) {
        return STRING_TO_DYE_COLOR.get(colorName.toLowerCase());
    }

    public static String getTranslationKey(String colorName) {
        return STRING_TO_STRING_TRANSLATION.get(colorName);
    }
}

