/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.brightable;

import com.benbenlaw.core.block.brightable.IBrightable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.lighting.LightEngine;

public class BrightGrassBlock
extends GrassBlock
implements BonemealableBlock,
IBrightable {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private final Block DIRT_BLOCK;
    private final Block SHORT_GRASS_BLOCK;
    private final ResourceKey<ConfiguredFeature<?, ?>> VEGETATION_PLACEMENT;

    public BrightGrassBlock(BlockBehaviour.Properties properties, ResourceKey<ConfiguredFeature<?, ?>> vegetationPlacements, Block dirt, Block shortGrassBlock) {
        super(properties);
        this.VEGETATION_PLACEMENT = vegetationPlacements;
        this.DIRT_BLOCK = dirt;
        this.SHORT_GRASS_BLOCK = shortGrassBlock;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.FALSE)).setValue((Property)SNOWY, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, SNOWY});
    }

    private static boolean canBeGrass(BlockState p_56824_, LevelReader p_56825_, BlockPos p_56826_) {
        BlockPos blockpos = p_56826_.above();
        BlockState blockstate = p_56825_.getBlockState(blockpos);
        if (blockstate.is(Blocks.SNOW) && (Integer)blockstate.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (blockstate.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockGetter)p_56825_, (BlockState)p_56824_, (BlockPos)p_56826_, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.getLightBlock((BlockGetter)p_56825_, blockpos));
        return i < p_56825_.getMaxLightLevel();
    }

    private static boolean canPropagate(BlockState p_56828_, LevelReader p_56829_, BlockPos p_56830_) {
        BlockPos blockpos = p_56830_.above();
        return BrightGrassBlock.canBeGrass(p_56828_, p_56829_, p_56830_) && !p_56829_.getFluidState(blockpos).is(FluidTags.WATER);
    }

    protected void randomTick(BlockState p_222508_, ServerLevel p_222509_, BlockPos p_222510_, RandomSource p_222511_) {
        if (!BrightGrassBlock.canBeGrass(p_222508_, (LevelReader)p_222509_, p_222510_)) {
            if (!p_222509_.isAreaLoaded(p_222510_, 1)) {
                return;
            }
            p_222509_.setBlockAndUpdate(p_222510_, this.DIRT_BLOCK.defaultBlockState());
        } else {
            if (!p_222509_.isAreaLoaded(p_222510_, 3)) {
                return;
            }
            if (p_222509_.getMaxLocalRawBrightness(p_222510_.above()) >= 9) {
                BlockState blockstate = this.defaultBlockState();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = p_222510_.offset(p_222511_.nextInt(3) - 1, p_222511_.nextInt(5) - 3, p_222511_.nextInt(3) - 1);
                    if (!p_222509_.getBlockState(blockpos).is(this.DIRT_BLOCK) || !BrightGrassBlock.canPropagate(blockstate, (LevelReader)p_222509_, blockpos)) continue;
                    p_222509_.setBlockAndUpdate(blockpos, (BlockState)blockstate.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(p_222509_.getBlockState(blockpos.above()).is(Blocks.SNOW))));
                }
            }
        }
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos blockPos, BlockState state) {
        level.registryAccess().registry(Registries.CONFIGURED_FEATURE).flatMap(registry -> registry.getHolder(this.VEGETATION_PLACEMENT)).ifPresent(feature -> {
            if (level.getBlockState(blockPos).is(state.getBlock()) && level.getBlockState(blockPos.above()).isAir()) {
                ((ConfiguredFeature)feature.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, blockPos.above());
            }
            for (int i = 0; i < 128; ++i) {
                BlockPos abovePos;
                BlockPos spreadPos = blockPos.offset(random.nextInt(5) - 2, random.nextInt(3) - 1, random.nextInt(5) - 2);
                BlockState spreadState = level.getBlockState(spreadPos);
                if (!spreadState.is(state.getBlock()) || !(random.nextFloat() < 0.3f) || !level.getBlockState(abovePos = spreadPos.above()).isAir()) continue;
                ((ConfiguredFeature)feature.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, abovePos);
            }
        });
    }
}

