/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.neoforge;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.mobz.IAbstractedAPI;
import net.mobz.neoforge.NeoforgeSpawnEgg;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoforgeRegistryWrapper
implements IAbstractedAPI {
    private final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"mobz");
    private final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"mobz");
    private final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"mobz");
    private final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"mobz");
    private final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"mobz");
    private Set<Supplier<?>> setters = new HashSet();
    private Set<Consumer<BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier>>> attribSuppliers = new HashSet<Consumer<BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier>>>();
    private Map<CreativeModeTab, List<Supplier<? extends ItemLike>>> tabContents = new HashMap<CreativeModeTab, List<Supplier<? extends ItemLike>>>();

    public NeoforgeRegistryWrapper(IEventBus eventBus) {
        this.BLOCKS.register(eventBus);
        this.ITEMS.register(eventBus);
        this.ENTITY_TYPES.register(eventBus);
        this.SOUNDS.register(eventBus);
        this.TABS.register(eventBus);
    }

    @Override
    public <T extends Item> Supplier<T> registerItem(String name, CreativeModeTab tab, Function<Item.Properties, T> constructor, Consumer<T> setter) {
        DeferredHolder regObj = this.ITEMS.register(name, () -> (Item)constructor.apply(new Item.Properties()));
        if (tab != null) {
            this.tabContents.get(tab).add((Supplier<? extends ItemLike>)regObj);
        }
        if (setter != null) {
            this.setters.add(() -> {
                Item val = (Item)regObj.get();
                setter.accept(val);
                return val;
            });
        }
        return regObj;
    }

    @Override
    public <T extends Block> Supplier<T> registerBlock(String name, CreativeModeTab tab, Function<BlockBehaviour.Properties, T> blockConstructor, BiFunction<T, Item.Properties, BlockItem> blockItemConstructor, Consumer<T> setter) {
        DeferredHolder regObj = this.BLOCKS.register(name, () -> (Block)blockConstructor.apply(BlockBehaviour.Properties.of()));
        if (tab != null) {
            this.tabContents.get(tab).add((Supplier<? extends ItemLike>)regObj);
        }
        if (setter != null) {
            this.setters.add(() -> {
                Block val = (Block)regObj.get();
                setter.accept(val);
                return val;
            });
        }
        this.registerItem(name, null, props -> (BlockItem)blockItemConstructor.apply((Object)((Block)regObj.get()), (Item.Properties)props), null);
        return regObj;
    }

    @Override
    public <E extends Entity, T extends EntityType<E>> Supplier<T> registerEntityType(String name, Supplier<T> constructor, Supplier<AttributeSupplier.Builder> attribModifierSupplier, Consumer<T> setter) {
        DeferredHolder regObj = this.ENTITY_TYPES.register(name, constructor);
        if (setter != null) {
            this.setters.add(() -> {
                EntityType val = (EntityType)regObj.get();
                setter.accept(val);
                return val;
            });
        }
        if (attribModifierSupplier != null) {
            this.attribSuppliers.add(regFunc -> {
                EntityType livingEntity = (EntityType)regObj.get();
                regFunc.accept(livingEntity, ((AttributeSupplier.Builder)attribModifierSupplier.get()).build());
            });
        }
        return regObj;
    }

    @Override
    public Supplier<Holder<SoundEvent>> registerSound(String name, ResourceLocation resloc, Consumer<SoundEvent> setter) {
        Supplier<SoundEvent> constructor = () -> SoundEvent.createVariableRangeEvent((ResourceLocation)resloc);
        DeferredHolder regObj = this.SOUNDS.register(name, constructor);
        if (setter != null) {
            this.setters.add(() -> {
                SoundEvent val = (SoundEvent)regObj.get();
                setter.accept(val);
                return val;
            });
        }
        return () -> regObj;
    }

    public void setAllRegistryObjectFields() {
        this.setters.forEach(Supplier::get);
        this.setters.clear();
        this.setters = null;
    }

    public void applyGlobalEntityAttrib(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> regFunc) {
        this.attribSuppliers.forEach(pair -> pair.accept(regFunc));
        this.attribSuppliers.clear();
        this.attribSuppliers = null;
    }

    @Override
    public CreativeModeTab tab(ResourceLocation resLoc, Supplier<ItemStack> iconSupplier) {
        String displayNameKey = "itemGroup." + resLoc.getNamespace() + "." + resLoc.getPath();
        LinkedList contents = new LinkedList();
        CreativeModeTab tab = CreativeModeTab.builder().title((Component)Component.translatable((String)displayNameKey)).icon(iconSupplier).displayItems((params, output) -> contents.stream().map(Supplier::get).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build();
        this.tabContents.put(tab, contents);
        this.TABS.register(resLoc.getPath(), () -> tab);
        return tab;
    }

    @Override
    public Supplier<SpawnEggItem> spawnEggOf(Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor, Item.Properties props) {
        return () -> new NeoforgeSpawnEgg(type, highlightColor, highlightColor, props);
    }

    @Override
    public Supplier<MobBucketItem> newMobBucketItem(Supplier<? extends EntityType<?>> entitySupplier, Supplier<? extends Fluid> fluidSupplier, Supplier<? extends SoundEvent> soundSupplier, Item.Properties properties) {
        return () -> new MobBucketItem((EntityType)entitySupplier.get(), (Fluid)fluidSupplier.get(), (SoundEvent)soundSupplier.get(), properties);
    }

    @Override
    public FoodProperties getFoodProperties(ItemStack stack, LivingEntity entity) {
        return stack.getFoodProperties(entity);
    }
}

