/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.neoforge;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.mobz.ILootTableAdder;
import net.mobz.MobZ;
import net.mobz.config.ClothConfig;
import net.mobz.data.Advancements;
import net.mobz.data.BlockTagProvider;
import net.mobz.data.EntityTagProvider;
import net.mobz.data.ItemTagProvider;
import net.mobz.data.JukeboxSongs;
import net.mobz.data.Loots;
import net.mobz.data.ModelDataProvider;
import net.mobz.data.Recipes;
import net.mobz.data.SpawnBiomeTagProvider;
import net.mobz.init.LootTableModifier;
import net.mobz.init.MobSpawnRestrictions;
import net.mobz.init.MobSpawns;
import net.mobz.neoforge.ClientRegistrationHandler;
import net.mobz.neoforge.NeoforgeRegistryWrapper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="mobz")
public class NeoforgeEntry {
    public static NeoforgeEntry instance;

    public NeoforgeEntry(IEventBus modBus, ModContainer modContainer) {
        if (instance != null) {
            throw new RuntimeException("Duplicated Class Instantiation: net.mobz.forge.MobZ");
        }
        instance = this;
        MobZ.platform = new NeoforgeRegistryWrapper(modBus);
        MobZ.configs = ClothConfig.get();
        Supplier<Runnable> toRun = () -> ClientRegistrationHandler::registerConfigGui;
        if (Dist.CLIENT == FMLEnvironment.dist) {
            toRun.get().run();
        }
        MobZ.invokeStaticFields();
    }

    @EventBusSubscriber(modid="mobz", bus=EventBusSubscriber.Bus.GAME)
    public static final class ForgeEventBusHandler {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onLootTableLoadEvent(LootTableLoadEvent event) {
            ILootTableAdder lootTableAdder = (lootTableIDs, range, entryBuilder) -> lootTableIDs.stream().filter(lootTableID -> lootTableID.location().equals((Object)event.getName())).forEach(lootTableID -> event.getTable().addPool(LootPool.lootPool().setRolls(range).add((LootPoolEntryContainer.Builder)entryBuilder).build()));
            LootTableModifier.loadAll(lootTableAdder);
        }
    }

    @EventBusSubscriber(modid="mobz", bus=EventBusSubscriber.Bus.MOD)
    public static final class ModEventBusHandler {
        @SubscribeEvent
        public static void onEntityAttributeCreationEvent(EntityAttributeCreationEvent event) {
            ((NeoforgeRegistryWrapper)MobZ.platform).applyGlobalEntityAttrib((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1));
        }

        @SubscribeEvent
        public static void onSpawnPlacementRegisterEvent(RegisterSpawnPlacementsEvent event) {
            new SpawnPlacementRegistar(event).registerAll();
        }

        @SubscribeEvent
        public static void onTabPopulation(BuildCreativeModeTabContentsEvent event) {
        }

        @SubscribeEvent
        public static void onDataGeneratorInvoked(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput packOutput = generator.getPackOutput();
            CompletableFuture lookupProvider = event.getLookupProvider();
            ExistingFileHelper exfh = event.getExistingFileHelper();
            RegistryAccess.Frozen registryAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
            HashMap<ResourceLocation, Pair<TagKey<Biome>, List<MobSpawnSettings.SpawnerData>>> rawMap = new HashMap<ResourceLocation, Pair<TagKey<Biome>, List<MobSpawnSettings.SpawnerData>>>();
            MobSpawns.collectAll(rawMap);
            RegistrySetBuilder.RegistryBootstrap biomeModifierPopulator = context -> {
                for (Map.Entry entry : rawMap.entrySet()) {
                    ResourceLocation resloc = (ResourceLocation)entry.getKey();
                    ResourceKey resKey = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)resloc);
                    Pair payload = (Pair)entry.getValue();
                    TagKey toBiomeWithTag = (TagKey)payload.getLeft();
                    HolderGetter biomeReg = context.lookup(toBiomeWithTag.registry());
                    HolderSet.Named biomeHolderSet = biomeReg.getOrThrow(toBiomeWithTag);
                    BiomeModifiers.AddSpawnsBiomeModifier modifier = new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomeHolderSet, (List)payload.getRight());
                    context.register(resKey, (Object)modifier);
                }
            };
            generator.addProvider(event.includeServer(), vanillaPackOutput -> new DatapackBuiltinEntriesProvider(vanillaPackOutput, lookupProvider, new RegistrySetBuilder().add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, biomeModifierPopulator).add(Registries.JUKEBOX_SONG, (RegistrySetBuilder.RegistryBootstrap)new JukeboxSongs()), Set.of("mobz")));
            generator.addProvider(event.includeServer(), (DataProvider)new SpawnBiomeTagProvider(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new BlockTagProvider(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new EntityTagProvider(packOutput, lookupProvider));
            generator.addProvider(event.includeClient(), (DataProvider)new ModelDataProvider(packOutput, (Registry<Item>)registryAccess.registryOrThrow(Registries.ITEM), resLoc -> exfh.exists(resLoc, PackType.CLIENT_RESOURCES)));
            generator.addProvider(event.includeServer(), vanillaPackOutput -> Loots.all(vanillaPackOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), vanillaPackOutput -> Advancements.all(vanillaPackOutput, lookupProvider));
        }

        private record SpawnPlacementRegistar(RegisterSpawnPlacementsEvent event) {
            private <T extends Mob> void register(EntityType<T> entityType, SpawnPlacementType spawnPlacementType, Heightmap.Types types, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
                this.event.register(entityType, spawnPlacementType, types, spawnPredicate, RegisterSpawnPlacementsEvent.Operation.OR);
            }

            private void registerAll() {
                MobSpawnRestrictions.applyAll(this::register);
            }
        }
    }
}

