/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.item.weapon;

import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public record SimpleTier(TagKey<Block> incorrectBlocksForDrops, int uses, float speed, float attackDamageBonus, int enchantmentValue, Supplier<Ingredient> repairIngredient) implements Tier
{
    public static SimpleTier of(int uses, float speed, float attackDamageBonus, int enchantmentValue) {
        return new SimpleTier(null, uses, speed, attackDamageBonus, enchantmentValue, () -> Ingredient.EMPTY);
    }

    public static SimpleTier of(int uses, float speed, float attackDamageBonus, int enchantmentValue, Supplier<? extends ItemLike> repairItem) {
        return new SimpleTier(null, uses, speed, attackDamageBonus, enchantmentValue, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)repairItem.get()}));
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.attackDamageBonus;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }

    @Override
    public String toString() {
        return "SimpleTier[incorrectBlocksForDrops=" + String.valueOf(this.incorrectBlocksForDrops) + ", uses=" + this.uses + ", speed=" + this.speed + ", attackDamageBonus=" + this.attackDamageBonus + ", enchantmentValue=" + this.enchantmentValue + ", repairIngredient=" + String.valueOf(this.repairIngredient) + "]";
    }
}

