/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.item.armor;

import java.util.EnumMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.mobz.MobZRarity;
import net.mobz.init.MobZItems;

public class SpeedShoeBase
extends ArmorItem {
    public static final EnumMap<ArmorItem.Type, Integer> DEFENSE_MAP1 = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 2);
        map.put(ArmorItem.Type.CHESTPLATE, 3);
        map.put(ArmorItem.Type.HELMET, 1);
    });
    public static final Holder<ArmorMaterial> MATERIAL1 = Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.tryBuild((String)"mobz", (String)"speed"), (Object)new ArmorMaterial(DEFENSE_MAP1, 10, SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MobZItems.BEAR_LEATHER.get()}), List.of(new ArmorMaterial.Layer(ResourceLocation.tryBuild((String)"mobz", (String)"speed"))), 0.0f, 0.0f));
    public static final EnumMap<ArmorItem.Type, Integer> DEFENSE_MAP2 = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 2);
        map.put(ArmorItem.Type.LEGGINGS, 3);
        map.put(ArmorItem.Type.CHESTPLATE, 4);
        map.put(ArmorItem.Type.HELMET, 2);
    });
    public static final Holder<ArmorMaterial> MATERIAL2 = Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.tryBuild((String)"mobz", (String)"speed2"), (Object)new ArmorMaterial(DEFENSE_MAP2, 12, SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.EMERALD}), List.of(new ArmorMaterial.Layer(ResourceLocation.tryBuild((String)"mobz", (String)"speed2"))), 0.0f, 0.0f));
    private final double speedBoost;

    public SpeedShoeBase(Holder<ArmorMaterial> material, ArmorItem.Type armorItemType, Item.Properties properties, double speedBoost) {
        super(material, armorItemType, properties);
        this.speedBoost = speedBoost;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        MobZRarity.UNCOMMON.addToTooltip(tooltip);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        ItemAttributeModifiers modifiers = super.getDefaultAttributeModifiers();
        return modifiers.withModifierAdded(Attributes.MOVEMENT_SPEED, new AttributeModifier(ResourceLocation.tryBuild((String)"mobz", (String)"speed"), this.speedBoost, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.getEquipmentSlot()));
    }
}

