/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.item.armor;

import java.util.EnumMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.mobz.MobZRarity;
import net.mobz.init.MobZItems;

public class LifeArmorBase
extends ArmorItem {
    public static final EnumMap<ArmorItem.Type, Integer> DURABILITY_MAP = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 30);
        map.put(ArmorItem.Type.LEGGINGS, 30);
        map.put(ArmorItem.Type.CHESTPLATE, 30);
        map.put(ArmorItem.Type.HELMET, 30);
    });
    public static final EnumMap<ArmorItem.Type, Integer> DEFENSE_MAP = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 2);
        map.put(ArmorItem.Type.LEGGINGS, 4);
        map.put(ArmorItem.Type.CHESTPLATE, 5);
        map.put(ArmorItem.Type.HELMET, 2);
    });
    public static final Holder<ArmorMaterial> MATERIAL = Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.tryBuild((String)"mobz", (String)"life"), (Object)new ArmorMaterial(DEFENSE_MAP, 10, SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MobZItems.HARDENEDMETAL_INGOT.get()}), List.of(new ArmorMaterial.Layer(ResourceLocation.tryBuild((String)"mobz", (String)"life")), new ArmorMaterial.Layer(ResourceLocation.tryBuild((String)"mobz", (String)"life"))), 0.0f, 0.0f));
    private final double lifeBoost = 3.0;

    public LifeArmorBase(ArmorItem.Type armorItemType, Item.Properties properties) {
        super(MATERIAL, armorItemType, properties.durability(DURABILITY_MAP.get(armorItemType).intValue()));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        MobZRarity.RARE.addToTooltip(tooltip);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        ItemAttributeModifiers modifiers = super.getDefaultAttributeModifiers();
        return modifiers.withModifierAdded(Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.tryBuild((String)"mobz", (String)"life"), this.lifeBoost, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.getEquipmentSlot()));
    }
}

