/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.item.armor;

import java.util.EnumMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.mobz.MobZRarity;
import net.mobz.init.MobZArmors;
import net.mobz.init.MobZItems;

public class AmatArmorBase
extends ArmorItem {
    public static final EnumMap<ArmorItem.Type, Integer> DURABILITY_MAP = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 34);
        map.put(ArmorItem.Type.LEGGINGS, 34);
        map.put(ArmorItem.Type.CHESTPLATE, 34);
        map.put(ArmorItem.Type.HELMET, 34);
    });
    public static final EnumMap<ArmorItem.Type, Integer> DEFENSE_MAP = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 2);
        map.put(ArmorItem.Type.LEGGINGS, 5);
        map.put(ArmorItem.Type.CHESTPLATE, 6);
        map.put(ArmorItem.Type.HELMET, 2);
    });
    public static final Holder<ArmorMaterial> MATERIAL = Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.tryBuild((String)"mobz", (String)"amat"), (Object)new ArmorMaterial(DEFENSE_MAP, 15, SoundEvents.ARMOR_EQUIP_DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MobZItems.AMAT_INGOT.get()}), List.of(new ArmorMaterial.Layer(ResourceLocation.tryBuild((String)"mobz", (String)"amat")), new ArmorMaterial.Layer(ResourceLocation.tryBuild((String)"mobz", (String)"amat"))), 1.0f, 0.0f));
    double attackSpeedBonus = 0.1;

    public AmatArmorBase(ArmorItem.Type armorItemType, Item.Properties properties) {
        super(MATERIAL, armorItemType, properties.durability(DURABILITY_MAP.get(armorItemType).intValue()));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        MobZRarity.RARE.addToTooltip(tooltip);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        ItemAttributeModifiers modifiers = super.getDefaultAttributeModifiers();
        return modifiers.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.tryBuild((String)"mobz", (String)"amat_attack_bonus"), this.attackSpeedBonus, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.getEquipmentSlot()));
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        LivingEntity bob = (LivingEntity)entity;
        MobEffectInstance fireResistance = new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 9, 0, false, false);
        if (bob.getItemBySlot(EquipmentSlot.FEET).is((Item)MobZArmors.AMAT_BOOTS.get()) && bob.getItemBySlot(EquipmentSlot.LEGS).is((Item)MobZArmors.AMAT_LEGGINGS.get()) && bob.getItemBySlot(EquipmentSlot.CHEST).is((Item)MobZArmors.AMAT_CHESTPLATE.get()) && bob.getItemBySlot(EquipmentSlot.HEAD).is((Item)MobZArmors.AMAT_HELMET.get()) && !world.isClientSide) {
            bob.addEffect(fireResistance);
        }
    }
}

