/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.mobz.MobZ;
import net.mobz.MobZRarity;
import net.mobz.block.TotemBase;
import net.mobz.init.MobZBlocks;
import net.mobz.item.SimpleItem;

public class SacrificeKnife
extends SimpleItem {
    public SacrificeKnife(Item.Properties settings) {
        super(settings.stacksTo(1).durability(5000), MobZRarity.UNCOMMON, true);
    }

    public static int getBloodCounter(ItemStack itemStack) {
        return itemStack.getDamageValue();
    }

    public static int getDryingNumber(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, (Object)0);
    }

    private static void setParam(ItemStack itemStack, int bloodCounter, int dryingNumber) {
        itemStack.setDamageValue(bloodCounter);
        itemStack.set(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, (Object)dryingNumber);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        int bloodCounter = SacrificeKnife.getBloodCounter(itemStack);
        int dryingNumber = SacrificeKnife.getDryingNumber(itemStack);
        if (user.getHealth() > 2.0f) {
            user.hurt(world.damageSources().magic(), 2.0f);
            if (dryingNumber < 4) {
                ++dryingNumber;
            }
            if (bloodCounter < 5000) {
                bloodCounter += 200;
            }
            SacrificeKnife.setParam(itemStack, bloodCounter, dryingNumber);
            return InteractionResultHolder.success((Object)itemStack);
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        int bloodCounter = SacrificeKnife.getBloodCounter(stack);
        int dryingNumber = SacrificeKnife.getDryingNumber(stack);
        if (bloodCounter > 0) {
            --bloodCounter;
        }
        if (bloodCounter == 0) {
            dryingNumber = 0;
        }
        SacrificeKnife.setParam(stack, bloodCounter, dryingNumber);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState state = world.getBlockState(pos);
        BlockState stateUp = world.getBlockState(pos.above());
        BlockState stateDown = world.getBlockState(pos.below());
        if (state.getBlock() == MobZBlocks.TOTEM_MIDDLE.get()) {
            if (stateUp.getBlock() == MobZBlocks.TOTEM_TOP.get() && stateDown.getBlock() == MobZBlocks.TOTEM_BASE.get()) {
                if (MobZ.configs.pillager_boss.enabled) {
                    ItemStack itemStack = context.getItemInHand();
                    int bloodCounter = SacrificeKnife.getBloodCounter(itemStack);
                    if (!((Boolean)stateDown.getValue((Property)TotemBase.ENABLED)).booleanValue()) {
                        if (bloodCounter > 4000) {
                            world.playSound(player, pos, SoundEvents.WITHER_SPAWN, SoundSource.HOSTILE, 1.0f, 1.0f);
                            MobZBlocks.TOTEM_BASE.get().trigger(world, pos.below());
                            SacrificeKnife.setParam(itemStack, 0, 0);
                            return InteractionResult.SUCCESS;
                        }
                        player.displayClientMessage((Component)Component.translatable((String)"text.mobz.sacrifice_knife_blood"), true);
                        return InteractionResult.PASS;
                    }
                    return InteractionResult.PASS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"text.mobz.pillagerspawnable"), true);
                return InteractionResult.PASS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"text.mobz.pillagermissing"), true);
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }
}

