/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.mobz.MobZRarity;

public class LevitationOrb
extends Item {
    public LevitationOrb(Item.Properties properties) {
        super(properties.durability(161));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
        MobZRarity.LEGENDARY.addToTooltip(tooltip);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (user instanceof Player) {
            ItemStack stack = user.getItemInHand(hand);
            if (stack.getDamageValue() == 0) {
                stack.setDamageValue(1);
                return InteractionResultHolder.success((Object)user.getItemInHand(hand));
            }
            return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
        }
        return InteractionResultHolder.pass((Object)user.getItemInHand(hand));
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int damage = stack.getDamageValue();
        if (damage > 0) {
            if (damage < stack.getMaxDamage()) {
                if (selected) {
                    player.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 9, 1, false, false));
                    if (++damage == stack.getMaxDamage()) {
                        player.getCooldowns().addCooldown((Item)this, stack.getMaxDamage());
                    }
                }
            } else if (!player.getCooldowns().isOnCooldown((Item)this)) {
                damage = 0;
            }
        }
        stack.setDamageValue(damage);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }
}

