/*
 * Decompiled with CFR 0.152.
 */
package net.mobz.init;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.mobz.MobZ;
import net.mobz.MobZRarity;
import net.mobz.MobZTabs;
import net.mobz.block.BossTrophy;
import net.mobz.block.EnderHeader;
import net.mobz.block.HardenedMetalBlock;
import net.mobz.block.TotemBase;
import net.mobz.block.TotemMiddle;
import net.mobz.block.TotemTop;

public class MobZBlocks {
    public static final Supplier<Block> AMAT_BLOCK = MobZBlocks.register("amat_block", props -> new Block(MobZBlocks.metal(props).emissiveRendering((blockstate, world, pos) -> true)){

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag options) {
            MobZRarity.UNCOMMON.addToTooltip(tooltip);
        }
    });
    public static final Supplier<Block> BOSS_BLOCK = MobZBlocks.register("boss_block", props -> new Block(MobZBlocks.metal(props).emissiveRendering((blockstate, world, pos) -> true)){

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag options) {
            MobZRarity.LEGENDARY.addToTooltip(tooltip);
        }
    }, props -> props.component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true));
    public static final Supplier<BossTrophy> BOSS_TROPHY = MobZBlocks.register("boss_trophy", props -> new BossTrophy(MobZBlocks.zombie_head(props)));
    public static final Supplier<EnderHeader> ENDER_HEADER = MobZBlocks.register("ender_header", props -> new EnderHeader(MobZBlocks.zombie_head(props)));
    public static final Supplier<HardenedMetalBlock> HARDENED_METAL_BLOCK = MobZBlocks.register("hardened_metal_block", props -> new HardenedMetalBlock(MobZBlocks.metal(props)));
    public static final Supplier<TotemBase> TOTEM_BASE = MobZBlocks.register("totem_base", props -> new TotemBase(MobZBlocks.oak_log(props)));
    public static final Supplier<TotemMiddle> TOTEM_MIDDLE = MobZBlocks.register("totem_middle", props -> new TotemMiddle(MobZBlocks.oak_log(props)));
    public static final Supplier<TotemTop> TOTEM_TOP = MobZBlocks.register("totem_top", props -> new TotemTop(MobZBlocks.oak_log(props)));

    private static BlockBehaviour.Properties zombie_head(BlockBehaviour.Properties props) {
        return props.strength(1.0f);
    }

    private static BlockBehaviour.Properties metal(BlockBehaviour.Properties props) {
        return props.mapColor(MapColor.METAL).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL);
    }

    private static BlockBehaviour.Properties oak_log(BlockBehaviour.Properties props) {
        return props.strength(2.0f).mapColor(MapColor.WOOD).ignitedByLava().sound(SoundType.WOOD);
    }

    private static <T extends Block> Supplier<T> register(String name, Function<BlockBehaviour.Properties, T> constructor) {
        return MobZBlocks.register(name, constructor, UnaryOperator.identity());
    }

    private static <T extends Block> Supplier<T> register(String name, Function<BlockBehaviour.Properties, T> constructor, UnaryOperator<Item.Properties> blockItemProps) {
        return MobZ.platform.registerBlock(name, MobZTabs.tab, constructor, (block, props) -> new BlockItem(block, (Item.Properties)blockItemProps.apply((Item.Properties)props)), null);
    }
}

